/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.DependencyManager;
import capsule.org.apache.maven.settings.Mirror;
import capsule.org.apache.maven.settings.Server;
import capsule.org.apache.maven.settings.Settings;
import capsule.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import capsule.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import capsule.org.apache.maven.settings.building.SettingsBuildingException;
import capsule.org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import capsule.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import capsule.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import capsule.org.eclipse.aether.repository.AuthenticationSelector;
import capsule.org.eclipse.aether.repository.MirrorSelector;
import capsule.org.eclipse.aether.repository.Proxy;
import capsule.org.eclipse.aether.repository.ProxySelector;
import capsule.org.eclipse.aether.util.repository.AuthenticationBuilder;
import capsule.org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import capsule.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import capsule.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import capsule.org.eclipse.aether.util.repository.DefaultProxySelector;
import capsule.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import capsule.org.sonatype.plexus.components.cipher.PlexusCipherException;
import capsule.org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

final class UserSettings {
    private static final Path MAVEN_HOME = UserSettings.getMavenHome();
    private static final UserSettings INSTANCE = new UserSettings();
    private final Settings settings;
    private final Path repositoryHome;

    public static UserSettings getInstance() {
        return INSTANCE;
    }

    private UserSettings() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(DependencyManager.DEFAULT_LOCAL_MAVEN.resolve("settings.xml").toFile());
        request.setGlobalSettingsFile(MAVEN_HOME != null ? MAVEN_HOME.resolve("conf").resolve("settings.xml").toFile() : null);
        request.setSystemProperties(UserSettings.getSystemProperties());
        try {
            this.settings = new DefaultSettingsBuilderFactory().newInstance().build(request).getEffectiveSettings();
            SettingsDecryptionResult result = UserSettings.newDefaultSettingsDecrypter().decrypt(new DefaultSettingsDecryptionRequest(this.settings));
            this.settings.setServers(result.getServers());
            this.settings.setProxies(result.getProxies());
            String settingsRepositoryHome = this.settings.getLocalRepository();
            this.repositoryHome = settingsRepositoryHome != null ? Paths.get(this.settings.getLocalRepository(), new String[0]) : DependencyManager.DEFAULT_LOCAL_MAVEN.resolve("repository");
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getMavenHome() {
        String mhome = DependencyManager.emptyToNull(System.getenv("M2_HOME"));
        if (mhome == null) {
            mhome = System.getProperty("maven.home");
        }
        return mhome != null ? Paths.get(mhome, new String[0]) : null;
    }

    private static Properties getSystemProperties() {
        Properties props = new Properties();
        UserSettings.getEnvProperties(props);
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    private static Properties getEnvProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        boolean envCaseInsensitive = UserSettings.isWindows();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (envCaseInsensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            key = "env." + key;
            props.put(key, entry.getValue());
        }
        return props;
    }

    public Path getRepositoryHome() {
        return this.repositoryHome;
    }

    public ProxySelector getProxySelector() {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (capsule.org.apache.maven.settings.Proxy proxy : this.settings.getProxies()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build()), proxy.getNonProxyHosts());
        }
        return selector;
    }

    public MirrorSelector getMirrorSelector() {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    public AuthenticationSelector getAuthSelector() {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : this.settings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector(selector);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static DefaultSettingsDecrypter newDefaultSettingsDecrypter() {
        DefaultSecDispatcher secDispatcher = new DefaultSecDispatcher(){
            {
                this._configurationFile = "~/.m2/settings-security.xml";
                try {
                    this._cipher = new DefaultPlexusCipher();
                }
                catch (PlexusCipherException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        DefaultSettingsDecrypter decrypter = new DefaultSettingsDecrypter();
        try {
            Field field = decrypter.getClass().getDeclaredField("securityDispatcher");
            field.setAccessible(true);
            field.set(decrypter, secDispatcher);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        return decrypter;
    }
}

