/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.protocol;

import capsule.org.apache.http.auth.AuthSchemeProvider;
import capsule.org.apache.http.auth.AuthState;
import capsule.org.apache.http.client.AuthCache;
import capsule.org.apache.http.client.CookieStore;
import capsule.org.apache.http.client.CredentialsProvider;
import capsule.org.apache.http.client.config.RequestConfig;
import capsule.org.apache.http.config.Lookup;
import capsule.org.apache.http.conn.routing.HttpRoute;
import capsule.org.apache.http.conn.routing.RouteInfo;
import capsule.org.apache.http.cookie.CookieOrigin;
import capsule.org.apache.http.cookie.CookieSpec;
import capsule.org.apache.http.cookie.CookieSpecProvider;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.protocol.HttpCoreContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientContext
extends HttpCoreContext {
    public static HttpClientContext adapt(HttpContext context) {
        if (context instanceof HttpClientContext) {
            return (HttpClientContext)context;
        }
        return new HttpClientContext(context);
    }

    public HttpClientContext(HttpContext context) {
        super(context);
    }

    public HttpClientContext() {
    }

    public RouteInfo getHttpRoute() {
        return this.getAttribute("http.route", HttpRoute.class);
    }

    public CookieStore getCookieStore() {
        return this.getAttribute("http.cookie-store", CookieStore.class);
    }

    public CookieSpec getCookieSpec() {
        return this.getAttribute("http.cookie-spec", CookieSpec.class);
    }

    public CookieOrigin getCookieOrigin() {
        return this.getAttribute("http.cookie-origin", CookieOrigin.class);
    }

    private <T> Lookup<T> getLookup(String name, Class<T> clazz) {
        return this.getAttribute(name, Lookup.class);
    }

    public Lookup<CookieSpecProvider> getCookieSpecRegistry() {
        return this.getLookup("http.cookiespec-registry", CookieSpecProvider.class);
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        return this.getLookup("http.authscheme-registry", AuthSchemeProvider.class);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.getAttribute("http.auth.credentials-provider", CredentialsProvider.class);
    }

    public AuthCache getAuthCache() {
        return this.getAttribute("http.auth.auth-cache", AuthCache.class);
    }

    public void setAuthCache(AuthCache authCache) {
        this.setAttribute("http.auth.auth-cache", authCache);
    }

    public AuthState getTargetAuthState() {
        return this.getAttribute("http.auth.target-scope", AuthState.class);
    }

    public AuthState getProxyAuthState() {
        return this.getAttribute("http.auth.proxy-scope", AuthState.class);
    }

    public RequestConfig getRequestConfig() {
        RequestConfig config = this.getAttribute("http.request-config", RequestConfig.class);
        return config != null ? config : RequestConfig.DEFAULT;
    }
}

