/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.conn.scheme;

import capsule.org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import capsule.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import capsule.org.apache.http.conn.scheme.SchemeLayeredSocketFactoryAdaptor2;
import capsule.org.apache.http.conn.scheme.SchemeSocketFactory;
import capsule.org.apache.http.util.Args;
import capsule.org.apache.http.util.LangUtils;
import java.util.Locale;

@Deprecated
public final class Scheme {
    private final String name;
    private final SchemeSocketFactory socketFactory;
    private final int defaultPort;
    private final boolean layered;
    private String stringRep;

    public Scheme(String name, int port, SchemeSocketFactory factory) {
        Args.notNull(name, "Scheme name");
        Args.check(port > 0 && port <= 65535, "Port is invalid");
        Args.notNull(factory, "Socket factory");
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.defaultPort = port;
        if (factory instanceof SchemeLayeredSocketFactory) {
            this.layered = true;
            this.socketFactory = factory;
        } else if (factory instanceof LayeredSchemeSocketFactory) {
            this.layered = true;
            this.socketFactory = new SchemeLayeredSocketFactoryAdaptor2((LayeredSchemeSocketFactory)factory);
        } else {
            this.layered = false;
            this.socketFactory = factory;
        }
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    public final SchemeSocketFactory getSchemeSocketFactory() {
        return this.socketFactory;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isLayered() {
        return this.layered;
    }

    public final int resolvePort(int port) {
        return port <= 0 ? this.defaultPort : port;
    }

    public final String toString() {
        if (this.stringRep == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            buffer.append(':');
            buffer.append(Integer.toString(this.defaultPort));
            this.stringRep = buffer.toString();
        }
        return this.stringRep;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Scheme) {
            Scheme that = (Scheme)obj;
            return this.name.equals(that.name) && this.defaultPort == that.defaultPort && this.layered == that.layered;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.defaultPort);
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.layered);
        return hash;
    }
}

