/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.auth;

import capsule.org.apache.http.FormattedHeader;
import capsule.org.apache.http.Header;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.auth.AuthenticationException;
import capsule.org.apache.http.auth.ChallengeState;
import capsule.org.apache.http.auth.ContextAwareAuthScheme;
import capsule.org.apache.http.auth.Credentials;
import capsule.org.apache.http.auth.MalformedChallengeException;
import capsule.org.apache.http.protocol.HTTP;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.util.Args;
import capsule.org.apache.http.util.CharArrayBuffer;
import java.util.Locale;

public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private ChallengeState challengeState;

    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + s);
        }
        this.parseChallenge(buffer, pos, buffer.length());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public String toString() {
        String name = this.getSchemeName();
        if (name != null) {
            return name.toUpperCase(Locale.ENGLISH);
        }
        return super.toString();
    }
}

