/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.client;

import capsule.org.apache.http.HttpHost;
import capsule.org.apache.http.auth.AuthScheme;
import capsule.org.apache.http.client.AuthCache;
import capsule.org.apache.http.conn.SchemePortResolver;
import capsule.org.apache.http.conn.UnsupportedSchemeException;
import capsule.org.apache.http.impl.conn.DefaultSchemePortResolver;
import capsule.org.apache.http.util.Args;
import java.util.HashMap;

public class BasicAuthCache
implements AuthCache {
    private final HashMap<HttpHost, AuthScheme> map = new HashMap();
    private final SchemePortResolver schemePortResolver;

    public BasicAuthCache(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public BasicAuthCache() {
        this(null);
    }

    protected HttpHost getKey(HttpHost host) {
        if (host.getPort() <= 0) {
            int port;
            try {
                port = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException ignore) {
                return host;
            }
            return new HttpHost(host.getHostName(), port, host.getSchemeName());
        }
        return host;
    }

    public void put(HttpHost host, AuthScheme authScheme) {
        Args.notNull(host, "HTTP host");
        this.map.put(this.getKey(host), authScheme);
    }

    public AuthScheme get(HttpHost host) {
        Args.notNull(host, "HTTP host");
        return this.map.get(this.getKey(host));
    }

    public void remove(HttpHost host) {
        Args.notNull(host, "HTTP host");
        this.map.remove(this.getKey(host));
    }

    public String toString() {
        return this.map.toString();
    }
}

