/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.cookie;

import capsule.org.apache.http.cookie.CookieSpec;
import capsule.org.apache.http.cookie.CookieSpecFactory;
import capsule.org.apache.http.cookie.CookieSpecProvider;
import capsule.org.apache.http.impl.cookie.BrowserCompatSpec;
import capsule.org.apache.http.params.HttpParams;
import capsule.org.apache.http.protocol.HttpContext;
import java.util.Collection;

public class BrowserCompatSpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final SecurityLevel securityLevel;

    public BrowserCompatSpecFactory(String[] datepatterns, SecurityLevel securityLevel) {
        this.datepatterns = datepatterns;
        this.securityLevel = securityLevel;
    }

    public BrowserCompatSpecFactory() {
        this(null, SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            return new BrowserCompatSpec(patterns, this.securityLevel);
        }
        return new BrowserCompatSpec(null, this.securityLevel);
    }

    public CookieSpec create(HttpContext context) {
        return new BrowserCompatSpec(this.datepatterns);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityLevel {
        SECURITYLEVEL_DEFAULT,
        SECURITYLEVEL_IE_MEDIUM;

    }
}

