/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.cookie;

import capsule.org.apache.http.cookie.ClientCookie;
import capsule.org.apache.http.cookie.Cookie;
import capsule.org.apache.http.cookie.CookieAttributeHandler;
import capsule.org.apache.http.cookie.CookieOrigin;
import capsule.org.apache.http.cookie.CookieRestrictionViolationException;
import capsule.org.apache.http.cookie.MalformedCookieException;
import capsule.org.apache.http.cookie.SetCookie;
import capsule.org.apache.http.cookie.SetCookie2;
import capsule.org.apache.http.util.Args;

public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

