/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.message;

import capsule.org.apache.http.HttpEntity;
import capsule.org.apache.http.HttpResponse;
import capsule.org.apache.http.HttpVersion;
import capsule.org.apache.http.ProtocolVersion;
import capsule.org.apache.http.ReasonPhraseCatalog;
import capsule.org.apache.http.StatusLine;
import capsule.org.apache.http.message.AbstractHttpMessage;
import capsule.org.apache.http.message.BasicStatusLine;
import capsule.org.apache.http.util.Args;
import java.util.Locale;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusline, ReasonPhraseCatalog catalog, Locale locale) {
        this.statusline = Args.notNull(statusline, "Status line");
        this.ver = statusline.getProtocolVersion();
        this.code = statusline.getStatusCode();
        this.reasonPhrase = statusline.getReasonPhrase();
        this.reasonCatalog = catalog;
        this.locale = locale;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            this.statusline = new BasicStatusLine(this.ver != null ? this.ver : HttpVersion.HTTP_1_1, this.code, this.reasonPhrase != null ? this.reasonPhrase : this.getReason(this.code));
        }
        return this.statusline;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    protected String getReason(int code) {
        return this.reasonCatalog != null ? this.reasonCatalog.getReason(code, this.locale != null ? this.locale : Locale.getDefault()) : null;
    }

    public String toString() {
        return this.getStatusLine() + " " + this.headergroup;
    }
}

