/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.protocol;

import capsule.org.apache.http.HttpConnection;
import capsule.org.apache.http.HttpHost;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.protocol.BasicHttpContext;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCoreContext
implements HttpContext {
    private final HttpContext context;

    public static HttpCoreContext adapt(HttpContext context) {
        Args.notNull(context, "HTTP context");
        if (context instanceof HttpCoreContext) {
            return (HttpCoreContext)context;
        }
        return new HttpCoreContext(context);
    }

    public HttpCoreContext(HttpContext context) {
        this.context = context;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    public <T> T getAttribute(String attribname, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }

    public HttpConnection getConnection() {
        return this.getAttribute("http.connection", HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute("http.request", HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean b = this.getAttribute("http.request_sent", Boolean.class);
        return b != null && b != false;
    }

    public HttpHost getTargetHost() {
        return this.getAttribute("http.target_host", HttpHost.class);
    }
}

