/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.protocol;

import capsule.org.apache.http.HttpConnection;
import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpHost;
import capsule.org.apache.http.HttpInetConnection;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.HttpRequestInterceptor;
import capsule.org.apache.http.HttpVersion;
import capsule.org.apache.http.ProtocolException;
import capsule.org.apache.http.ProtocolVersion;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.protocol.HttpCoreContext;
import capsule.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

