/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.InputLocation;
import capsule.org.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Contributor
implements InputLocationTracker,
Serializable,
Cloneable {
    private String name;
    private String email;
    private String url;
    private String organization;
    private String organizationUrl;
    private List<String> roles;
    private String timezone;
    private Properties properties;
    private Map<Object, InputLocation> locations;

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public Contributor clone() {
        try {
            Contributor copy = (Contributor)super.clone();
            if (this.roles != null) {
                copy.roles = new ArrayList<String>();
                copy.roles.addAll(this.roles);
            }
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

