/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.ConfigurationContainer;
import capsule.org.apache.maven.model.Dependency;
import capsule.org.apache.maven.model.PluginExecution;
import capsule.org.codehaus.plexus.util.xml.Xpp3Dom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Plugin
extends ConfigurationContainer
implements Serializable,
Cloneable {
    private String groupId = "capsule.org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private String extensions;
    private List<PluginExecution> executions;
    private List<Dependency> dependencies;
    private Object goals;
    private Map<String, PluginExecution> executionMap = null;
    private String key = null;

    @Override
    public Plugin clone() {
        try {
            Plugin copy = (Plugin)super.clone();
            if (this.executions != null) {
                copy.executions = new ArrayList<PluginExecution>();
                for (PluginExecution pluginExecution : this.executions) {
                    copy.executions.add(pluginExecution.clone());
                }
            }
            if (this.dependencies != null) {
                copy.dependencies = new ArrayList<Dependency>();
                for (Dependency dependency : this.dependencies) {
                    copy.dependencies.add(dependency.clone());
                }
            }
            if (this.goals != null) {
                copy.goals = new Xpp3Dom((Xpp3Dom)this.goals);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public List<PluginExecution> getExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList<PluginExecution>();
        }
        return this.executions;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setExecutions(List<PluginExecution> executions) {
        this.executions = executions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void setGoals(Object goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = Plugin.constructKey(this.groupId, this.artifactId);
        }
        return this.key;
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }
}

