/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.InputLocation;
import capsule.org.apache.maven.model.InputLocationTracker;
import capsule.org.apache.maven.model.Plugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PluginContainer
implements InputLocationTracker,
Serializable,
Cloneable {
    private List<Plugin> plugins;
    private Map<Object, InputLocation> locations;

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public PluginContainer clone() {
        try {
            PluginContainer copy = (PluginContainer)super.clone();
            if (this.plugins != null) {
                copy.plugins = new ArrayList<Plugin>();
                for (Plugin item : this.plugins) {
                    copy.plugins.add(item.clone());
                }
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }
}

