/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model.io;

import capsule.org.apache.commons.lang3.Validate;
import capsule.org.apache.maven.model.InputSource;
import capsule.org.apache.maven.model.Model;
import capsule.org.apache.maven.model.io.ModelParseException;
import capsule.org.apache.maven.model.io.ModelReader;
import capsule.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import capsule.org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import capsule.org.codehaus.plexus.util.IOUtil;
import capsule.org.codehaus.plexus.util.ReaderFactory;
import capsule.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class DefaultModelReader
implements ModelReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            Model model = this.read(ReaderFactory.newXmlReader(input), this.isStrict(options), this.getSource(options));
            return model;
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("capsule.org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("capsule.org.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private Model read(Reader reader, boolean strict, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict, source);
            }
            return new MavenXpp3Reader().read(reader, strict);
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }
}

