/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.settings.io;

import capsule.org.apache.commons.lang3.Validate;
import capsule.org.apache.maven.settings.Settings;
import capsule.org.apache.maven.settings.io.SettingsParseException;
import capsule.org.apache.maven.settings.io.SettingsReader;
import capsule.org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import capsule.org.codehaus.plexus.util.IOUtil;
import capsule.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("capsule.org.apache.maven.settings.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

