/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.artifact;

import capsule.org.eclipse.aether.artifact.AbstractArtifact;
import capsule.org.eclipse.aether.artifact.ArtifactType;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultArtifact
extends AbstractArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public DefaultArtifact(String groupId, String artifactId, String extension, String version) {
        this(groupId, artifactId, "", extension, version);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this(groupId, artifactId, classifier, extension, version, null, (File)null);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, ArtifactType type) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = classifier != null || type == null ? DefaultArtifact.emptify(classifier) : DefaultArtifact.emptify(type.getClassifier());
        this.extension = extension != null || type == null ? DefaultArtifact.emptify(extension) : DefaultArtifact.emptify(type.getExtension());
        this.version = DefaultArtifact.emptify(version);
        this.file = null;
        this.properties = DefaultArtifact.merge(properties, type != null ? type.getProperties() : null);
    }

    private static Map<String, String> merge(Map<String, String> dominant, Map<String, String> recessive) {
        Map<String, String> properties;
        if ((dominant == null || dominant.isEmpty()) && (recessive == null || recessive.isEmpty())) {
            properties = Collections.emptyMap();
        } else {
            properties = new HashMap();
            if (recessive != null) {
                properties.putAll(recessive);
            }
            if (dominant != null) {
                properties.putAll(dominant);
            }
            properties = Collections.unmodifiableMap(properties);
        }
        return properties;
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, File file) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = DefaultArtifact.copyProperties(properties);
    }

    DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, File file, Map<String, String> properties) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

