/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.artifact;

import capsule.org.eclipse.aether.artifact.ArtifactType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultArtifactType
implements ArtifactType {
    private final String id;
    private final String extension;
    private final String classifier;
    private final Map<String, String> properties;

    public DefaultArtifactType(String id) {
        this(id, id, "", "none", false, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language) {
        this(id, extension, classifier, language, true, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language, boolean constitutesBuildPath, boolean includesDependencies) {
        if (id == null || id.length() < 0) {
            throw new IllegalArgumentException("no type id specified");
        }
        this.id = id;
        this.extension = DefaultArtifactType.emptify(extension);
        this.classifier = DefaultArtifactType.emptify(classifier);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", id);
        props.put("language", language != null && language.length() > 0 ? language : "none");
        props.put("includesDependencies", Boolean.toString(includesDependencies));
        props.put("constitutesBuildPath", Boolean.toString(constitutesBuildPath));
        this.properties = Collections.unmodifiableMap(props);
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

