/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.artifact.ArtifactType;
import capsule.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import java.util.HashMap;
import java.util.Map;

class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session) {
        return CachingArtifactTypeRegistry.newInstance(session.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate) {
        return delegate != null ? new CachingArtifactTypeRegistry(delegate) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate) {
        this.delegate = delegate;
        this.types = new HashMap<String, ArtifactType>();
    }

    public ArtifactType get(String typeId) {
        ArtifactType type = this.types.get(typeId);
        if (type == null) {
            type = this.delegate.get(typeId);
            this.types.put(typeId, type);
        }
        return type;
    }
}

