/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.impl.LocalRepositoryProvider;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponent;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponents;
import capsule.org.eclipse.aether.internal.impl.Utils;
import capsule.org.eclipse.aether.repository.LocalRepository;
import capsule.org.eclipse.aether.repository.LocalRepositoryManager;
import capsule.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import capsule.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        PrioritizedComponents factories = new PrioritizedComponents(session);
        for (LocalRepositoryManagerFactory factory : this.managerFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                LocalRepositoryManager localRepositoryManager = ((LocalRepositoryManagerFactory)factory.getComponent()).newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(localRepositoryManager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, localRepositoryManager);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getBasedir());
                    this.logger.debug(buffer.toString());
                }
                return localRepositoryManager;
            }
            catch (NoLocalRepositoryManagerException noLocalRepositoryManagerException) {
                errors.add(noLocalRepositoryManagerException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain local repository manager for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No local repository managers registered");
        } else {
            buffer.append("Cannot access ").append(repository.getBasedir());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available factories ");
            factories.list(buffer);
        }
        throw new NoLocalRepositoryManagerException(repository, buffer.toString(), errors.size() == 1 ? (NoLocalRepositoryManagerException)errors.get(0) : null);
    }
}

