/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponent;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponents;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import capsule.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import capsule.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import capsule.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public final class DefaultRepositoryLayoutProvider
implements RepositoryLayoutProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<RepositoryLayoutFactory> factories = new ArrayList<RepositoryLayoutFactory>();

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setRepositoryLayoutFactories(locator.getServices(RepositoryLayoutFactory.class));
    }

    public DefaultRepositoryLayoutProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositoryLayoutProvider setRepositoryLayoutFactories(Collection<RepositoryLayoutFactory> factories) {
        this.factories = factories == null ? new ArrayList<RepositoryLayoutFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryLayout newRepositoryLayout(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        PrioritizedComponents factories = new PrioritizedComponents(session);
        for (RepositoryLayoutFactory factory : this.factories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryLayoutException> errors = new ArrayList<NoRepositoryLayoutException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                RepositoryLayout repositoryLayout = ((RepositoryLayoutFactory)factory.getComponent()).newInstance(session, repository);
                return repositoryLayout;
            }
            catch (NoRepositoryLayoutException noRepositoryLayoutException) {
                errors.add(noRepositoryLayoutException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain layout factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No layout factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available layout factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryLayoutException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryLayoutException)errors.get(0) : null);
    }
}

