/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.resolution;

import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.repository.ArtifactRepository;
import capsule.org.eclipse.aether.resolution.ArtifactRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactResult {
    private final ArtifactRequest request;
    private List<Exception> exceptions;
    private Artifact artifact;
    private ArtifactRepository repository;

    public ArtifactResult(ArtifactRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("resolution request has not been specified");
        }
        this.request = request;
        this.exceptions = Collections.emptyList();
    }

    public ArtifactRequest getRequest() {
        return this.request;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public boolean isResolved() {
        return this.getArtifact() != null && this.getArtifact().getFile() != null;
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepository();
    }
}

