/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.resolution;

import capsule.org.eclipse.aether.RepositoryException;
import capsule.org.eclipse.aether.resolution.VersionResult;

public class VersionResolutionException
extends RepositoryException {
    private final transient VersionResult result;

    public VersionResolutionException(VersionResult result) {
        super(VersionResolutionException.getMessage(result), VersionResolutionException.getCause(result));
        this.result = result;
    }

    private static String getMessage(VersionResult result) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("Failed to resolve version");
        if (result != null) {
            buffer.append(" for ").append(result.getRequest().getArtifact());
            if (!result.getExceptions().isEmpty()) {
                buffer.append(": ").append(result.getExceptions().iterator().next().getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(VersionResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }
}

