/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transfer;

import capsule.org.eclipse.aether.RepositoryException;

public class ChecksumFailureException
extends RepositoryException {
    private final String expected;
    private final String actual;
    private final boolean retryWorthy;

    public ChecksumFailureException(String expected, String actual) {
        super("Checksum validation failed, expected " + expected + " but is " + actual);
        this.expected = expected;
        this.actual = actual;
        this.retryWorthy = true;
    }

    public ChecksumFailureException(String message) {
        this(false, message, null);
    }

    public ChecksumFailureException(Throwable cause) {
        this("Checksum validation failed" + ChecksumFailureException.getMessage(": ", cause), cause);
    }

    public ChecksumFailureException(String message, Throwable cause) {
        this(false, message, cause);
    }

    public ChecksumFailureException(boolean retryWorthy, String message, Throwable cause) {
        super(message, cause);
        this.actual = "";
        this.expected = "";
        this.retryWorthy = retryWorthy;
    }

    public boolean isRetryWorthy() {
        return this.retryWorthy;
    }
}

