/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transport.file;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.connector.transport.Transporter;
import capsule.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import capsule.org.eclipse.aether.transfer.NoTransporterException;
import capsule.org.eclipse.aether.transport.file.FileTransporter;
import javax.inject.Named;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public FileTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, FileTransporter.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new FileTransporter(repository, this.logger);
    }
}

