/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.util.artifact;

import capsule.org.eclipse.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactIdUtils {
    public static String toVersionlessId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifactIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier());
        }
        return id;
    }

    public static String toVersionlessId(String groupId, String artifactId, String extension, String classifier) {
        return ArtifactIdUtils.concat(groupId, artifactId, extension, classifier).toString();
    }

    private static StringBuilder concat(String groupId, String artifactId, String extension, String classifier) {
        StringBuilder buffer = new StringBuilder(128);
        if (groupId != null) {
            buffer.append(groupId);
        }
        buffer.append(':');
        if (artifactId != null) {
            buffer.append(artifactId);
        }
        buffer.append(':');
        if (extension != null) {
            buffer.append(extension);
        }
        if (classifier != null && classifier.length() > 0) {
            buffer.append(':').append(classifier);
        }
        return buffer;
    }

    public static boolean equalsId(Artifact artifact1, Artifact artifact2) {
        if (artifact1 == null || artifact2 == null) {
            return false;
        }
        if (!ArtifactIdUtils.eq(artifact1.getArtifactId(), artifact2.getArtifactId())) {
            return false;
        }
        if (!ArtifactIdUtils.eq(artifact1.getGroupId(), artifact2.getGroupId())) {
            return false;
        }
        if (!ArtifactIdUtils.eq(artifact1.getExtension(), artifact2.getExtension())) {
            return false;
        }
        if (!ArtifactIdUtils.eq(artifact1.getClassifier(), artifact2.getClassifier())) {
            return false;
        }
        return ArtifactIdUtils.eq(artifact1.getVersion(), artifact2.getVersion());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }
}

