/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.util.concurrency;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class WorkerThreadFactory
implements ThreadFactory {
    private final ThreadFactory factory = Executors.defaultThreadFactory();
    private final String namePrefix;
    private final AtomicInteger threadIndex;
    private static final AtomicInteger poolIndex = new AtomicInteger();

    public WorkerThreadFactory(String namePrefix) {
        this.namePrefix = (namePrefix != null && namePrefix.length() > 0 ? namePrefix : WorkerThreadFactory.getCallerSimpleClassName() + '-') + poolIndex.getAndIncrement() + '-';
        this.threadIndex = new AtomicInteger();
    }

    private static String getCallerSimpleClassName() {
        StackTraceElement[] stack = new Exception().getStackTrace();
        if (stack == null || stack.length <= 2) {
            return "Worker-";
        }
        String name = stack[2].getClassName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    public Thread newThread(Runnable r) {
        Thread thread = this.factory.newThread(r);
        thread.setName(this.namePrefix + this.threadIndex.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

