/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.util.graph.visitor;

import capsule.org.eclipse.aether.graph.DependencyFilter;
import capsule.org.eclipse.aether.graph.DependencyNode;
import capsule.org.eclipse.aether.graph.DependencyVisitor;
import capsule.org.eclipse.aether.util.graph.visitor.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathRecordingDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final List<List<DependencyNode>> paths;
    private final Stack<DependencyNode> parents;
    private final Map<DependencyNode, Object> visited;
    private final boolean excludeChildrenOfMatches;

    public PathRecordingDependencyVisitor(DependencyFilter filter) {
        this(filter, true);
    }

    public PathRecordingDependencyVisitor(DependencyFilter filter, boolean excludeChildrenOfMatches) {
        this.filter = filter;
        this.excludeChildrenOfMatches = excludeChildrenOfMatches;
        this.paths = new ArrayList<List<DependencyNode>>();
        this.parents = new Stack();
        this.visited = new IdentityHashMap<DependencyNode, Object>(128);
    }

    public List<List<DependencyNode>> getPaths() {
        return this.paths;
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        boolean accept = this.filter == null || this.filter.accept(node, this.parents);
        this.parents.push(node);
        if (accept) {
            DependencyNode[] path = new DependencyNode[this.parents.size()];
            int n = this.parents.size();
            for (int i = 0; i < n; ++i) {
                path[n - i - 1] = (DependencyNode)this.parents.get(i);
            }
            this.paths.add(Arrays.asList(path));
            if (this.excludeChildrenOfMatches) {
                return false;
            }
        }
        return this.visited.put(node, Boolean.TRUE) == null;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        this.parents.pop();
        this.visited.remove(node);
        return true;
    }
}

