/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.util.version;

import capsule.org.eclipse.aether.version.Version;
import capsule.org.eclipse.aether.version.VersionRange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnionVersionRange
implements VersionRange {
    private final Set<VersionRange> ranges;
    private final VersionRange.Bound lowerBound;
    private final VersionRange.Bound upperBound;

    public static VersionRange from(Collection<? extends VersionRange> ranges) {
        if (ranges != null && ranges.size() == 1) {
            return ranges.iterator().next();
        }
        return new UnionVersionRange(ranges);
    }

    private UnionVersionRange(Collection<? extends VersionRange> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            this.ranges = Collections.emptySet();
            this.upperBound = null;
            this.lowerBound = null;
        } else {
            int c;
            this.ranges = new HashSet<VersionRange>(ranges);
            VersionRange.Bound lowerBound = null;
            VersionRange.Bound upperBound = null;
            for (VersionRange range : this.ranges) {
                VersionRange.Bound lb = range.getLowerBound();
                if (lb == null) {
                    lowerBound = null;
                    break;
                }
                if (lowerBound == null) {
                    lowerBound = lb;
                    continue;
                }
                c = lb.getVersion().compareTo(lowerBound.getVersion());
                if (c >= 0 && (c != 0 || lowerBound.isInclusive())) continue;
                lowerBound = lb;
            }
            for (VersionRange range : this.ranges) {
                VersionRange.Bound ub = range.getUpperBound();
                if (ub == null) {
                    upperBound = null;
                    break;
                }
                if (upperBound == null) {
                    upperBound = ub;
                    continue;
                }
                c = ub.getVersion().compareTo(upperBound.getVersion());
                if (c <= 0 && (c != 0 || upperBound.isInclusive())) continue;
                upperBound = ub;
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }
    }

    @Override
    public boolean containsVersion(Version version) {
        for (VersionRange range : this.ranges) {
            if (!range.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VersionRange.Bound getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public VersionRange.Bound getUpperBound() {
        return this.upperBound;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnionVersionRange that = (UnionVersionRange)obj;
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        int hash = 97 * this.ranges.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        for (VersionRange range : this.ranges) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(range);
        }
        return buffer.toString();
    }
}

