/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.junit;

import com.adaptavist.tm4j.junit.annotation.TestCase;
import com.adaptavist.tm4j.junit.builder.CustomFormatContainerBuilder;
import com.adaptavist.tm4j.junit.decorator.TestDescriptionDecorator;
import com.adaptavist.tm4j.junit.file.CustomFormatFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionListener
extends RunListener {
    private final Logger logger = LoggerFactory.getLogger(ExecutionListener.class);
    private CustomFormatContainerBuilder customFormatContainerBuilder;
    private List<String> errorMessages = new ArrayList<String>();

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        this.customFormatContainerBuilder = new CustomFormatContainerBuilder();
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.customFormatContainerBuilder.registerFailure(new TestDescriptionDecorator(failure.getDescription()));
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        this.checkTestCaseAnnotation(description);
        this.customFormatContainerBuilder.registerFinished(new TestDescriptionDecorator(description));
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        if (!this.errorMessages.isEmpty()) {
            this.printErrorMessages();
        } else {
            CustomFormatFile.generateCustomFormatFile(this.customFormatContainerBuilder.getCustomFormatContainer());
        }
    }

    private void checkTestCaseAnnotation(Description description) {
        TestCase testCaseAnnotation;
        TestCase testCase = testCaseAnnotation = description != null ? (TestCase)description.getAnnotation(TestCase.class) : null;
        if (testCaseAnnotation != null && this.allFieldsAreEmpty(testCaseAnnotation)) {
            this.errorMessages.add("[ERROR - Test Management For Jira] You must inform at least one parameter to TestCase annotation in method " + description.getDisplayName());
        }
    }

    private boolean allFieldsAreEmpty(TestCase testCaseAnnotation) {
        return StringUtils.isEmpty((CharSequence)testCaseAnnotation.key()) && StringUtils.isEmpty((CharSequence)testCaseAnnotation.name());
    }

    private void printErrorMessages() {
        this.logger.error("[ERROR - Test Management For Jira] TM4J Results JSON File was not generated due to the following errors");
        this.errorMessages.forEach(errorMessage -> this.logger.error(errorMessage));
    }
}

