/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.address.api.location;

import com.adobe.cq.address.api.Address;
import com.adobe.cq.address.api.AddressException;
import com.adobe.cq.address.api.location.Coordinates;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Location
extends SlingAdaptable {
    private static final Logger log = LoggerFactory.getLogger(Location.class);
    private final Address address;
    private String[] defaultAddressFields = new String[]{"street1", "street2", "city", "state", "zip", "country"};
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String PHONE = "phone";
    public static final String HOURS = "hours";

    public Location(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot instantiate address. Resource cannot be null.");
        }
        this.address = resource.adaptTo(Address.class);
    }

    public String getPath() {
        return this.address.getPath();
    }

    public String getTitle() {
        return this.address.getProperty("jcr:title", "");
    }

    public String getDescription() {
        return this.address.getProperty("jcr:description", "");
    }

    public void setCoordinates(Coordinates coord) throws AddressException {
        this.address.setProperty(LATITUDE, coord.getLat());
        this.address.setProperty(LONGITUDE, coord.getLng());
    }

    public Coordinates getCoordinates() {
        Double lng;
        Double lat = (Double)((Object)this.address.getProperty(LATITUDE, Double.class));
        Coordinates coords = new Coordinates(lat, lng = (Double)((Object)this.address.getProperty(LONGITUDE, Double.class)));
        if (!coords.validate().booleanValue()) {
            return null;
        }
        return coords;
    }

    public String getPhone() {
        return this.address.getProperty(PHONE, "");
    }

    public void setPhone(String phone) throws AddressException {
        this.address.setProperty(PHONE, phone);
    }

    public String[] getHours() {
        return this.address.getProperty(HOURS, null);
    }

    public void setHours(String[] hours) throws AddressException {
        this.address.setProperty(HOURS, hours);
    }

    public String getFullAddress() {
        return this.getFullAddress(this.defaultAddressFields);
    }

    public String getFullAddress(String[] fields) {
        StringBuilder sb = new StringBuilder();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                sb.append(this.address.getProperty(fields[i], "")).append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Location && ((Location)obj).getTitle().equals(this.getTitle());
    }

    public int hashCode() {
        return this.getTitle().hashCode();
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Address.class) {
            return (AdapterType)this.address;
        }
        AdapterType ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.address.adaptTo(type);
        }
        return ret;
    }
}

