/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PlacedOrder;
import com.adobe.cq.commerce.api.PlacedOrderResult;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.common.AbstractJcrCommerceService;
import com.adobe.cq.commerce.common.DefaultJcrCartEntry;
import com.adobe.cq.commerce.common.DefaultJcrPlacedOrder;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher;
import com.adobe.cq.commerce.impl.promotion.JcrPromotionImpl;
import com.adobe.cq.commerce.impl.promotion.JcrVoucherImpl;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.Language;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.personalization.ContextSessionPersistence;
import com.day.cq.personalization.UserPropertiesUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.servlet.http.Cookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractJcrCommerceSession
implements CommerceSession {
    protected static final Logger log = LoggerFactory.getLogger(AbstractJcrCommerceSession.class);
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    protected Resource resource;
    protected ResourceResolver resolver;
    protected AbstractJcrCommerceService commerceService;
    protected Locale locale = Locale.US;
    protected Locale userLocale = null;
    protected String PN_UNIT_PRICE = "price";
    protected String PN_ORDER_ID = "orderId";
    protected RoundingMode roundingMode = RoundingMode.HALF_UP;
    protected BigDecimal PRODUCT_TAX_RATE = new BigDecimal("0.06");
    protected BigDecimal SHIPPING_TAX_RATE = BigDecimal.ZERO;
    private String orderId;
    protected static final int COOKIE_SIZE_LIMIT = 4050;
    protected static final String PN_COMMERCE_PERSISTENCE_OVERFLOW = "cpo";
    protected static final String ORDERS_BASE_PATH = "/etc/commerce/orders/";
    protected static final String ORDERS_PATH_DATE_TEMPLATE = "yyyy/MM/dd";
    protected static final String ORDER_NAME = "order";
    protected static final String USER_ORDERS_PATH = "/commerce/orders/";
    protected static final String USER_ORDERS_DATE_TEMPLATE = "'order'-yyyy-MMM-dd";
    protected List<CommerceSession.CartEntry> cart = new ArrayList<CommerceSession.CartEntry>();
    protected List<Voucher> vouchers = new ArrayList<Voucher>();
    protected List<Promotion> promotions = new ArrayList<Promotion>();
    protected Map<String, String> orderDetails = new HashMap<String, String>();
    protected List<PriceInfo> prices;
    @Deprecated
    protected NumberFormat formatter = NumberFormat.getCurrencyInstance(this.locale);

    public AbstractJcrCommerceSession(AbstractJcrCommerceService commerceService, SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws CommerceException {
        this.request = request;
        this.response = response;
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        this.commerceService = commerceService;
        Language lang = commerceService.serviceContext().languageManager.getCqLanguage(resource);
        if (lang != null && lang.getLocale().getCountry().length() > 0) {
            this.locale = lang.getLocale();
            this.loadCart();
        } else {
            Resource firstProductPage;
            this.loadCart();
            if (resource.getPath().startsWith("/content")) {
                log.warn("Unable to extract locale from page {}, falling back to default locale {}.", (Object)resource.getPath(), (Object)this.locale);
            } else if (this.cart.size() > 0 && (firstProductPage = this.resolver.getResource(this.cart.get(0).getProduct().getPagePath())) != null && (lang = commerceService.serviceContext().languageManager.getCqLanguage(firstProductPage)) != null && lang.getLocale().getCountry().length() > 0) {
                this.locale = lang.getLocale();
                this.calcOrder();
            }
        }
    }

    AbstractJcrCommerceSession(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    protected void loadCart() throws CommerceException {
        try {
            String promotionCountString;
            String voucherCountString;
            Map<String, String> cartStore = ContextSessionPersistence.getStore(this.request, "CART", "CommercePersistence");
            String entryCountString = cartStore.get("entryCount");
            if (entryCountString != null && entryCountString.length() > 0) {
                int entryCount = Integer.parseInt(entryCountString);
                for (int i = 0; i < entryCount; ++i) {
                    try {
                        Product product = this.commerceService.getProduct(cartStore.get("product" + i));
                        if (product == null) {
                            throw new Exception();
                        }
                        int quantity = Integer.parseInt(cartStore.get("quantity" + i));
                        if (quantity != quantity) {
                            throw new Exception();
                        }
                        if (quantity <= 0) continue;
                        this.doAddCartEntry(product, quantity);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Unable to load product from cookie: {}, qty: {}", (Object)cartStore.get("product" + i), (Object)cartStore.get("quantity" + i));
                    }
                }
            }
            if ((voucherCountString = cartStore.get("voucherCount")) != null && voucherCountString.length() > 0) {
                int voucherCount = Integer.parseInt(voucherCountString);
                for (int i = 0; i < voucherCount; ++i) {
                    try {
                        JcrVoucherImpl voucher = new JcrVoucherImpl(this.resolver.getResource(cartStore.get("voucher" + i)));
                        if (voucher == null) {
                            throw new Exception();
                        }
                        this.vouchers.add((Voucher)voucher);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Unable to load voucher from ClientContext: {}", (Object)cartStore.get("voucher" + i));
                    }
                }
            }
            if ((promotionCountString = cartStore.get("promotionCount")) != null && promotionCountString.length() > 0) {
                int promotionCount = Integer.parseInt(promotionCountString);
                for (int i = 0; i < promotionCount; ++i) {
                    try {
                        JcrPromotionImpl promotion = new JcrPromotionImpl(this.resolver.getResource(cartStore.get("promotion" + i)));
                        if (promotion == null) {
                            throw new Exception();
                        }
                        this.promotions.add((Promotion)promotion);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Unable to load promotion from ClientContext: {}", (Object)cartStore.get("promotion" + i));
                    }
                }
            }
            this.orderDetails = ContextSessionPersistence.getStore(this.request, "ORDER", "CommercePersistence");
            if (this.orderDetails.get(this.PN_ORDER_ID) == null) {
                this.orderDetails.put(this.PN_ORDER_ID, UUID.randomUUID().toString());
            }
            this.calcOrder();
        }
        catch (Exception e) {
            throw new CommerceException("Failed to load cart from client context: ", e);
        }
    }

    protected void saveCart() throws CommerceException {
        try {
            int i;
            HashMap<String, String> cartStore = new HashMap<String, String>();
            for (CommerceSession.CartEntry entry : this.cart) {
                cartStore.put("product" + entry.getEntryIndex(), entry.getProduct().getPath());
                cartStore.put("quantity" + entry.getEntryIndex(), "" + entry.getQuantity());
            }
            cartStore.put("entryCount", "" + this.getCartEntryCount());
            for (i = 0; i < this.vouchers.size(); ++i) {
                cartStore.put("voucher" + i, this.vouchers.get(i).getPath());
            }
            cartStore.put("voucherCount", String.valueOf(this.vouchers.size()));
            for (i = 0; i < this.promotions.size(); ++i) {
                cartStore.put("promotion" + i, this.promotions.get(i).getPath());
            }
            cartStore.put("promotionCount", String.valueOf(this.promotions.size()));
            HashMap<String, Map<String, String>> stores = new HashMap<String, Map<String, String>>();
            stores.put("CART", cartStore);
            stores.put("ORDER", this.orderDetails);
            this.saveCommerceCookie(stores);
        }
        catch (Exception e) {
            throw new CommerceException("Failed to save cart to cookie: ", e);
        }
    }

    private void saveCommerceCookie(Map<String, Map<String, String>> stores) {
        String cpl_param;
        Cookie commercePersistence = this.request.getCookie("CommercePersistence");
        String oldValue = commercePersistence == null ? null : commercePersistence.getValue();
        class MySlingHttpServletResponseWrapper
        extends SlingHttpServletResponseWrapper {
            private final List<Cookie> cookies;

            MySlingHttpServletResponseWrapper(SlingHttpServletResponse wrappedResponse) {
                super(wrappedResponse);
                this.cookies = new ArrayList<Cookie>();
            }

            public void addCookie(Cookie cookie) {
                super.addCookie(cookie);
                if (cookie != null) {
                    this.cookies.add(cookie);
                }
            }
        }
        MySlingHttpServletResponseWrapper responseWrapper = new MySlingHttpServletResponseWrapper(this.response);
        ContextSessionPersistence.putStores(this.request, responseWrapper, stores, "CommercePersistence");
        boolean isCpoSet = false;
        for (Cookie cookie : responseWrapper.cookies) {
            String value;
            if (!"CommercePersistence".equals(cookie.getName()) || (value = cookie.getValue()) == null || value.length() <= 4050) continue;
            if (oldValue != null) {
                cookie.setValue(oldValue);
            } else {
                cookie.setValue("");
            }
            ContextSessionPersistence.put(this.request, this.response, PN_COMMERCE_PERSISTENCE_OVERFLOW, PN_COMMERCE_PERSISTENCE_OVERFLOW);
            isCpoSet = true;
            break;
        }
        if (!isCpoSet && (cpl_param = ContextSessionPersistence.get(this.request, PN_COMMERCE_PERSISTENCE_OVERFLOW)) != null && cpl_param.trim().length() > 0) {
            ContextSessionPersistence.put(this.request, this.response, PN_COMMERCE_PERSISTENCE_OVERFLOW, "");
        }
    }

    public static boolean hasCookieOverflow(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        boolean error;
        String cpl_param = ContextSessionPersistence.get(request, PN_COMMERCE_PERSISTENCE_OVERFLOW);
        boolean bl = error = cpl_param != null && PN_COMMERCE_PERSISTENCE_OVERFLOW.equals(cpl_param.trim());
        if (error) {
            ContextSessionPersistence.put(request, response, PN_COMMERCE_PERSISTENCE_OVERFLOW, "");
        }
        return error;
    }

    @Override
    public void logout() throws CommerceException {
    }

    protected Locale getLocale() {
        return this.userLocale != null ? this.userLocale : this.locale;
    }

    @Override
    public void setUserLocale(Locale locale) {
        this.userLocale = locale;
        try {
            this.calcOrder();
        }
        catch (CommerceException e) {
            log.error("Could not recalculate order: ", (Throwable)e);
        }
    }

    @Override
    public Locale getUserLocale() {
        return this.userLocale;
    }

    @Override
    public List<PriceInfo> getProductPriceInfo(Product product) throws CommerceException {
        return this.getProductPriceInfo(product, null);
    }

    @Override
    public List<PriceInfo> getProductPriceInfo(Product product, Predicate filter) throws CommerceException {
        ArrayList<PriceInfo> prices = new ArrayList<PriceInfo>();
        BigDecimal preTax = product.getProperty(this.PN_UNIT_PRICE, BigDecimal.class);
        if (preTax == null) {
            preTax = BigDecimal.ZERO;
        }
        BigDecimal tax = preTax.multiply(this.PRODUCT_TAX_RATE);
        String currencyCode = Currency.getInstance(this.getLocale()).getCurrencyCode();
        PriceInfo price = new PriceInfo(preTax, this.getLocale());
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", (Object)new HashSet<String>(Arrays.asList("UNIT", "PRE_TAX", currencyCode)));
        prices.add(price);
        price = new PriceInfo(tax, this.getLocale());
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", (Object)new HashSet<String>(Arrays.asList("UNIT", "TAX", currencyCode)));
        prices.add(price);
        price = new PriceInfo(preTax.add(tax), this.getLocale());
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", (Object)new HashSet<String>(Arrays.asList("UNIT", "POST_TAX", currencyCode)));
        prices.add(price);
        CollectionUtils.filter(prices, (Predicate)filter);
        return prices;
    }

    @Override
    public String getProductPrice(Product product) throws CommerceException {
        return this.getProductPrice(product, null);
    }

    @Override
    public String getProductPrice(Product product, Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product, filter);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    @Override
    public int getCartEntryCount() {
        return this.cart.size();
    }

    @Override
    public List<CommerceSession.CartEntry> getCartEntries() {
        return this.cart;
    }

    @Override
    public List<PriceInfo> getCartPriceInfo(Predicate filter) {
        if (filter != null) {
            ArrayList<PriceInfo> filteredPrices = new ArrayList<PriceInfo>();
            CollectionUtils.select(this.prices, (Predicate)filter, filteredPrices);
            return filteredPrices;
        }
        return this.prices;
    }

    @Override
    public String getCartPrice(Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getCartPriceInfo(filter);
        return prices.isEmpty() ? "" : prices.get(0).getFormattedString();
    }

    @Override
    public void addCartEntry(Product product, int quantity) throws CommerceException {
        this.doAddCartEntry(product, quantity);
        this.calcCart();
        this.saveCart();
    }

    protected void doAddCartEntry(Product product, int quantity) throws CommerceException {
        for (CommerceSession.CartEntry existingEntry : this.cart) {
            DefaultJcrCartEntry existingEntryImpl = (DefaultJcrCartEntry)existingEntry;
            if (!existingEntryImpl.getProduct().getPath().equals(product.getPath())) continue;
            existingEntryImpl.setQuantity(existingEntryImpl.getQuantity() + quantity);
            this.calcEntry(existingEntryImpl.getEntryIndex());
            return;
        }
        DefaultJcrCartEntry newEntry = this.newCartEntryImpl(this.cart.size(), product, quantity);
        this.cart.add(newEntry);
        this.doCalcEntry(newEntry, null, this.getLocale());
    }

    public DefaultJcrCartEntry newCartEntryImpl(int index, Product product, int quantity) {
        return new DefaultJcrCartEntry(index, product, quantity);
    }

    @Override
    public void modifyCartEntry(int entryNumber, int quantity) throws CommerceException {
        if (entryNumber < this.cart.size()) {
            DefaultJcrCartEntry entry = (DefaultJcrCartEntry)this.cart.get(entryNumber);
            entry.setQuantity(quantity);
            this.calcEntry(entryNumber);
        }
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void deleteCartEntry(int entryNumber) throws CommerceException {
        if (entryNumber < this.cart.size()) {
            this.cart.remove(entryNumber);
        }
        for (int i = 0; i < this.cart.size(); ++i) {
            DefaultJcrCartEntry entry = (DefaultJcrCartEntry)this.cart.get(i);
            entry.setEntryIndex(i);
        }
        this.calcCart();
        this.saveCart();
    }

    public void calcEntry(int index) throws CommerceException {
        this.doCalcEntry((DefaultJcrCartEntry)this.cart.get(index), null, this.getLocale());
    }

    protected void doCalcEntry(DefaultJcrCartEntry entry, BigDecimal discount, Locale locale) throws CommerceException {
        BigDecimal totalPrice;
        BigDecimal tax;
        BigDecimal preTaxPrice;
        BigDecimal unitPrice = entry.getProduct().getProperty(this.PN_UNIT_PRICE, BigDecimal.class);
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
            preTaxPrice = BigDecimal.ZERO;
            tax = BigDecimal.ZERO;
            totalPrice = BigDecimal.ZERO;
        } else {
            preTaxPrice = unitPrice.multiply(new BigDecimal(entry.getQuantity()));
            if (discount != null) {
                preTaxPrice = preTaxPrice.subtract(discount);
            }
            tax = preTaxPrice.multiply(this.PRODUCT_TAX_RATE).setScale(2, this.roundingMode);
            totalPrice = preTaxPrice.add(tax);
        }
        entry.setPrice(new PriceInfo(preTaxPrice, locale), "LINE", "PRE_TAX");
        entry.setPrice(new PriceInfo(tax, locale), "LINE", "TAX");
        entry.setPrice(new PriceInfo(totalPrice, locale), "LINE", "POST_TAX");
        entry.setPrice(new PriceInfo(unitPrice, locale), "UNIT", "PRE_TAX");
    }

    protected void setPrice(PriceInfo priceInfo, String ... types) {
        if (this.prices == null) {
            this.prices = new ArrayList<PriceInfo>();
        }
        ArrayList<String> typeList = new ArrayList<String>(Arrays.asList(types));
        typeList.add(priceInfo.getCurrency().getCurrencyCode());
        int index = this.prices.size();
        for (int i = 0; i < this.prices.size(); ++i) {
            PriceInfo price = this.prices.get(i);
            Set priceTypes = (Set)price.get("com.adobe.cq.commerce.common.PriceFilter.types");
            if (!CollectionUtils.isEqualCollection((Collection)priceTypes, typeList)) continue;
            index = i;
            break;
        }
        priceInfo.put("com.adobe.cq.commerce.common.PriceFilter.types", (Object)new HashSet<String>(typeList));
        if (index == this.prices.size()) {
            this.prices.add(priceInfo);
        } else {
            this.prices.set(index, priceInfo);
        }
    }

    protected void calcCart() {
        String currencyCode = Currency.getInstance(this.getLocale()).getCurrencyCode();
        BigDecimal cartPreTaxPrice = BigDecimal.ZERO;
        BigDecimal cartTax = BigDecimal.ZERO;
        BigDecimal cartTotalPrice = BigDecimal.ZERO;
        BigDecimal appliedDiscount = BigDecimal.ZERO;
        List<Promotion> promotions = this.getActivePromotions();
        try {
            for (CommerceSession.CartEntry cartEntry : this.cart) {
                this.doCalcEntry((DefaultJcrCartEntry)cartEntry, null, this.getLocale());
                for (Promotion p : promotions) {
                    try {
                        PromotionHandler ph = p.adaptTo(PromotionHandler.class);
                        PriceInfo discount = ph.applyCartEntryPromotion(this, p, cartEntry);
                        if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                        this.doCalcEntry((DefaultJcrCartEntry)cartEntry, discount.getAmount(), this.getLocale());
                        appliedDiscount = appliedDiscount.add(discount.getAmount());
                        break;
                    }
                    catch (Exception e) {
                        log.error("Applying cart line item promotion failed: ", (Throwable)e);
                    }
                }
                cartPreTaxPrice = cartPreTaxPrice.add(cartEntry.getPriceInfo(new PriceFilter("PRE_TAX", currencyCode)).get(0).getAmount());
                cartTax = cartTax.add(cartEntry.getPriceInfo(new PriceFilter("TAX", currencyCode)).get(0).getAmount());
                cartTotalPrice = cartTotalPrice.add(cartEntry.getPriceInfo(new PriceFilter("POST_TAX", currencyCode)).get(0).getAmount());
            }
            this.setPrice(new PriceInfo(cartPreTaxPrice, this.getLocale()), "CART", "PRE_TAX");
            this.setPrice(new PriceInfo(cartTax, this.getLocale()), "CART", "TAX");
            this.setPrice(new PriceInfo(cartTotalPrice, this.getLocale()), "CART", "POST_TAX");
            this.setPrice(new PriceInfo(appliedDiscount, this.getLocale()), "DISCOUNT", "PRODUCTS");
        }
        catch (CommerceException e) {
            log.error("Calculating cart failed: ", (Throwable)e);
        }
    }

    public List<Promotion> getActivePromotions() {
        ArrayList<Promotion> activePromotions = new ArrayList<Promotion>(this.promotions.size());
        for (Promotion promotion : this.promotions) {
            if (!promotion.isValid()) continue;
            activePromotions.add(promotion);
        }
        for (Voucher voucher : this.vouchers) {
            Promotion promotion;
            if (!voucher.isValid(this.request)) continue;
            String path = (String)((Object)voucher.getConfig().get("promotion", String.class));
            Resource resource = path == null ? null : this.resolver.getResource(path);
            Promotion promotion2 = promotion = resource == null ? null : resource.adaptTo(Promotion.class);
            if (promotion == null || !promotion.isValid()) {
                log.error("Cart contains voucher with invalid promotion: " + voucher.getPath());
                continue;
            }
            activePromotions.add(promotion);
        }
        Collections.sort(activePromotions, new Comparator<Promotion>(){

            @Override
            public int compare(Promotion p1, Promotion p2) {
                return Long.valueOf(p2.getPriority()).compareTo(p1.getPriority());
            }
        });
        return activePromotions;
    }

    @Override
    public boolean supportsClientsidePromotionResolution() {
        return true;
    }

    @Override
    public void addPromotion(String path) throws CommerceException {
        Promotion p = this.commerceService.getPromotion(path);
        if (p == null) {
            throw new CommerceException("Invalid promotion: " + path);
        }
        this.promotions.add(p);
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void removePromotion(String path) throws CommerceException {
        for (int i = 0; i < this.promotions.size(); ++i) {
            if (!this.promotions.get(i).getPath().equals(path)) continue;
            this.promotions.remove(i--);
        }
        this.calcCart();
        this.saveCart();
    }

    @Override
    public List<PromotionInfo> getPromotions() throws CommerceException {
        ArrayList<PromotionInfo> promotionInfos = new ArrayList<PromotionInfo>(0);
        for (Promotion p : this.promotions) {
            String description = null;
            Map<Integer, String> messages = null;
            PromotionHandler handler = p.adaptTo(PromotionHandler.class);
            if (handler != null) {
                description = handler.getDescription(this.request, this, p);
                messages = handler.getMessages(this.request, this, p);
            }
            if (description == null || description.length() == 0) {
                description = p.getDescription();
            }
            if (messages != null) {
                for (Integer key : messages.keySet()) {
                    if (key == -1) continue;
                    promotionInfos.add(new PromotionInfo(p.getPath(), p.getTitle(), PromotionInfo.PromotionStatus.FIRED, null, messages.get(key), key));
                }
            }
            promotionInfos.add(new PromotionInfo(p.getPath(), p.getTitle(), PromotionInfo.PromotionStatus.FIRED, description, messages != null ? messages.get(-1) : null, null));
        }
        return promotionInfos;
    }

    protected BigDecimal getShipping(String method) {
        throw new UnsupportedOperationException();
    }

    protected void calcOrder() throws CommerceException {
        BigDecimal orderShipping;
        this.calcCart();
        String currencyCode = Currency.getInstance(this.getLocale()).getCurrencyCode();
        PriceInfo cartTax = this.getCartPriceInfo(new PriceFilter("TAX", currencyCode)).get(0);
        PriceInfo cartPreTaxPrice = this.getCartPriceInfo(null).get(0);
        BigDecimal orderSubTotal = cartPreTaxPrice.getAmount();
        try {
            String shippingMethod = this.orderDetails.get("shipping-option");
            orderShipping = this.getShipping(shippingMethod);
        }
        catch (Exception e) {
            orderShipping = BigDecimal.ZERO;
        }
        BigDecimal orderShippingTax = orderShipping.multiply(this.SHIPPING_TAX_RATE).setScale(2, this.roundingMode);
        BigDecimal orderTotalTax = cartTax.getAmount().add(orderShippingTax);
        BigDecimal orderTotalPrice = orderSubTotal.add(orderTotalTax.add(orderShipping));
        this.setPrice(new PriceInfo(orderShipping, this.getLocale()), "SHIPPING", "PRE_TAX");
        this.setPrice(new PriceInfo(orderShippingTax, this.getLocale()), "SHIPPING", "TAX");
        this.setPrice(new PriceInfo(orderShipping.add(orderShippingTax), this.getLocale()), "SHIPPING", "POST_TAX");
        this.setPrice(new PriceInfo(orderShipping, this.getLocale()), "SHIPPING", "PRE_PROMO");
        this.setPrice(new PriceInfo(orderTotalPrice, this.getLocale()), "ORDER", "TOTAL");
        this.setPrice(new PriceInfo(orderSubTotal, this.getLocale()), "ORDER", "SUB_TOTAL");
        this.setPrice(new PriceInfo(orderTotalTax, this.getLocale()), "ORDER", "TAX");
        BigDecimal orderDiscount = BigDecimal.ZERO;
        List<Promotion> promotions = this.getActivePromotions();
        for (Promotion p : promotions) {
            try {
                PromotionHandler ph = p.adaptTo(PromotionHandler.class);
                PriceInfo discount = ph.applyOrderPromotion(this, p);
                if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                orderSubTotal = orderSubTotal.subtract(discount.getAmount());
                orderDiscount = orderDiscount.add(discount.getAmount());
                break;
            }
            catch (Exception e) {
                log.error("Applying order-level promotion failed: ", (Throwable)e);
            }
        }
        BigDecimal shippingDiscount = BigDecimal.ZERO;
        for (Promotion p : promotions) {
            try {
                PromotionHandler ph = p.adaptTo(PromotionHandler.class);
                PriceInfo discount = ph.applyShippingPromotion(this, p);
                if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                orderShipping = orderShipping.subtract(discount.getAmount());
                shippingDiscount = shippingDiscount.add(discount.getAmount());
                break;
            }
            catch (Exception e) {
                log.error("Applying shipping promotion failed: ", (Throwable)e);
            }
        }
        PriceInfo productDiscount = this.getCartPriceInfo(new PriceFilter("DISCOUNT", "PRODUCTS", currencyCode)).get(0);
        BigDecimal totalDiscount = orderDiscount.add(shippingDiscount).add(productDiscount.getAmount());
        orderShippingTax = orderShipping.multiply(this.SHIPPING_TAX_RATE).setScale(2, this.roundingMode);
        orderTotalTax = cartTax.getAmount().add(orderShippingTax);
        orderTotalPrice = orderSubTotal.add(orderTotalTax.add(orderShipping));
        this.setPrice(new PriceInfo(orderShipping, this.getLocale()), "SHIPPING", "PRE_TAX");
        this.setPrice(new PriceInfo(orderShippingTax, this.getLocale()), "SHIPPING", "TAX");
        this.setPrice(new PriceInfo(orderShipping.add(orderShippingTax), this.getLocale()), "SHIPPING", "POST_TAX");
        this.setPrice(new PriceInfo(orderTotalPrice, this.getLocale()), "ORDER", "TOTAL");
        this.setPrice(new PriceInfo(orderSubTotal, this.getLocale()), "ORDER", "SUB_TOTAL");
        this.setPrice(new PriceInfo(orderTotalTax, this.getLocale()), "ORDER", "TAX");
        this.setPrice(new PriceInfo(totalDiscount, this.getLocale()), "DISCOUNT", "TOTAL");
        this.setPrice(new PriceInfo(orderDiscount, this.getLocale()), "DISCOUNT", "ORDER");
        this.setPrice(new PriceInfo(shippingDiscount, this.getLocale()), "DISCOUNT", "SHIPPING");
    }

    @Override
    public List<VoucherInfo> getVoucherInfos() throws CommerceException {
        ArrayList<VoucherInfo> list = new ArrayList<VoucherInfo>();
        for (Voucher voucher : this.vouchers) {
            list.add(new VoucherInfo(voucher.getCode(), voucher.getPath(), voucher.getTitle(), voucher.getDescription(), voucher.isValid(this.request), voucher.getMessage(this.request)));
        }
        return list;
    }

    @Override
    public void addVoucher(String code) throws CommerceException {
        PromotionManager pm = this.resolver.adaptTo(PromotionManager.class);
        Voucher voucher = pm.findVoucher(this.request, code);
        if (voucher == null) {
            I18n i18n = new I18n(this.request);
            throw new CommerceException(i18n.get("Invalid voucher code."));
        }
        if (!voucher.isValid(this.request)) {
            throw new CommerceException(voucher.getMessage(this.request));
        }
        for (Voucher existingVoucher : this.vouchers) {
            if (!existingVoucher.getCode().equals(voucher.getCode())) continue;
            I18n i18n = new I18n(this.request);
            throw new CommerceException(i18n.get("Voucher already added."));
        }
        this.vouchers.add(voucher);
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void removeVoucher(String code) throws CommerceException {
        for (int i = 0; i < this.vouchers.size(); ++i) {
            if (!this.vouchers.get(i).getCode().equals(code)) continue;
            this.vouchers.remove(i--);
        }
        this.calcCart();
        this.saveCart();
    }

    @Override
    public String getOrderId() throws CommerceException {
        if (this.orderId == null) {
            return this.orderDetails.get(this.PN_ORDER_ID);
        }
        return this.orderId;
    }

    protected void doUpdateOrderDetails(Map<String, String> delta) throws CommerceException {
        boolean shippingAddressSame = StringUtils.isNotEmpty((String)delta.get("shippingAddressSameAsBilling"));
        HashMap<String, String> paymentDetails = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : delta.entrySet()) {
            String key = entry.getKey();
            if (key.equals("shippingAddressSameAsBilling")) continue;
            if (key.startsWith("payment.")) {
                paymentDetails.put(key, entry.getValue());
                continue;
            }
            this.orderDetails.put(key, entry.getValue());
            if (!shippingAddressSame || !key.startsWith("billing.")) continue;
            String shippingKey = key.replace("billing.", "shipping.");
            this.orderDetails.put(shippingKey, entry.getValue());
        }
        if (!paymentDetails.isEmpty()) {
            this.orderDetails.put("paymentToken", this.tokenizePaymentInfo(paymentDetails));
        }
    }

    @Override
    public void updateOrder(Map<String, Object> delta) throws CommerceException {
        HashMap<String, String> newDelta = new HashMap<String, String>();
        ValueMapDecorator vm = new ValueMapDecorator(delta);
        for (String key : vm.keySet()) {
            String value = (String)((Object)vm.get(key, String.class));
            if (value == null) continue;
            newDelta.put(key, value);
        }
        this.doUpdateOrderDetails(newDelta);
        this.saveCart();
    }

    @Override
    public Map<String, String> getOrderDetails() throws CommerceException {
        if (this.orderDetails.isEmpty() || this.orderDetails.size() == 1 && this.orderDetails.containsKey(this.PN_ORDER_ID)) {
            try {
                Session userSession = this.resolver.adaptTo(Session.class);
                UserProperties userProperties = (UserProperties)this.request.adaptTo(UserProperties.class);
                if (userProperties != null && !UserPropertiesUtil.isAnonymous(userProperties)) {
                    UserManager um = ((JackrabbitSession)userSession).getUserManager();
                    Authorizable authorizable = um.getAuthorizable(userProperties.getAuthorizableID());
                    UserPropertiesManager upm = this.commerceService.serviceContext().userPropertiesService.createUserPropertiesManager(this.resolver);
                    UserProperties profile = upm.getUserProperties(authorizable.getID(), "profile");
                    this.orderDetails.put("billing.firstname", profile.getProperty("givenName"));
                    this.orderDetails.put("billing.lastname", profile.getProperty("familyName"));
                    this.orderDetails.put("billing.street1", profile.getProperty("streetAddress"));
                    this.orderDetails.put("billing.city", profile.getProperty("city"));
                    this.orderDetails.put("billing.state", profile.getProperty("region"));
                    this.orderDetails.put("billing.zip", profile.getProperty("postalCode"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.orderDetails;
    }

    @Override
    public Map<String, Object> getOrder() throws CommerceException {
        return new HashMap<String, Object>(this.getOrderDetails());
    }

    protected String tokenizePaymentInfo(Map<String, String> paymentDetails) throws CommerceException {
        return UUID.randomUUID().toString();
    }

    protected void doPlaceOrder(Map<String, String> orderDetailsDelta) throws CommerceException {
        this.doUpdateOrderDetails(orderDetailsDelta);
        String orderPath = this.savePlacedOrderVendorRecord();
        this.savePlacedOrderShopperRecord();
        this.orderId = this.getOrderId();
        this.cart.clear();
        this.vouchers.clear();
        this.orderDetails.clear();
        this.saveCart();
        this.initiateOrderProcessing(orderPath);
    }

    protected void initiateOrderProcessing(String orderPath) throws CommerceException {
    }

    protected String getOrderStatus(String orderId) throws CommerceException {
        return "";
    }

    @Override
    public void placeOrder(Map<String, Object> delta) throws CommerceException {
        HashMap<String, String> newDelta = new HashMap<String, String>();
        ValueMapDecorator vm = new ValueMapDecorator(delta);
        for (String key : vm.keySet()) {
            String value = (String)((Object)vm.get(key, String.class));
            if (value == null) continue;
            newDelta.put(key, value);
        }
        this.doPlaceOrder(newDelta);
    }

    protected void initializeOrderStorage(Session adminSession) throws RepositoryException {
        String ordersNodePath = ORDERS_BASE_PATH.substring(0, ORDERS_BASE_PATH.length() - 1);
        if (!adminSession.nodeExists(ordersNodePath)) {
            JcrUtil.createPath(ordersNodePath, "nt:unstructured", adminSession);
            AccessControlUtils.denyAllToEveryone(adminSession, ordersNodePath);
            adminSession.save();
        }
    }

    protected String savePlacedOrderVendorRecord() throws CommerceException {
        String vendorRecordPath = null;
        Calendar now = Calendar.getInstance(this.locale);
        Session adminSession = null;
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(ORDERS_PATH_DATE_TEMPLATE);
            String orderPath = ORDERS_BASE_PATH + dateFormatter.format(now.getTime()) + "/" + ORDER_NAME;
            adminSession = this.commerceService.serviceContext().slingRepository.loginAdministrative(null);
            this.initializeOrderStorage(adminSession);
            Node vendorRecord = JcrUtil.createPath(orderPath, true, "sling:Folder", "nt:unstructured", adminSession, false);
            this.writeOrder(vendorRecord, now, adminSession);
            adminSession.save();
            vendorRecordPath = vendorRecord.getPath();
        }
        catch (Exception e) {
            throw new CommerceException("Failed to save completed order: ", e);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
        return vendorRecordPath;
    }

    protected void savePlacedOrderShopperRecord() throws CommerceException {
        Calendar now = Calendar.getInstance(this.locale);
        try {
            Session userSession = this.resolver.adaptTo(Session.class);
            UserProperties userProperties = (UserProperties)this.request.adaptTo(UserProperties.class);
            if (userProperties != null && !UserPropertiesUtil.isAnonymous(userProperties)) {
                UserManager um = ((JackrabbitSession)userSession).getUserManager();
                Authorizable user = um.getAuthorizable(userProperties.getAuthorizableID());
                SimpleDateFormat dateFormatter = new SimpleDateFormat(USER_ORDERS_DATE_TEMPLATE);
                String userOrderPath = user.getPath() + USER_ORDERS_PATH + dateFormatter.format(now.getTime());
                Node shopperRecord = JcrUtil.createPath(userOrderPath, true, "sling:Folder", "nt:unstructured", userSession, false);
                this.writeOrder(shopperRecord, now, userSession);
                userSession.save();
            }
        }
        catch (RepositoryException e) {
            throw new CommerceException("Failed to save completed order to user's home: ", e);
        }
    }

    protected void writeOrder(Node orderNode, Calendar placedTime, Session session) throws CommerceException, RepositoryException {
        String info;
        ArrayList<String> entries = new ArrayList<String>();
        for (CommerceSession.CartEntry entry : this.cart) {
            entries.add(this.serializeCartEntry(entry));
        }
        orderNode.setProperty("cartItems", entries.toArray(new String[entries.size()]));
        String currencyCode = Currency.getInstance(this.getLocale()).getCurrencyCode();
        BigDecimal cartPreTaxPrice = this.getCartPriceInfo(new PriceFilter("PRE_TAX", currencyCode)).get(0).getAmount();
        BigDecimal orderShipping = this.getCartPriceInfo(new PriceFilter("SHIPPING", currencyCode)).get(0).getAmount();
        BigDecimal orderTotalTax = this.getCartPriceInfo(new PriceFilter("ORDER", "TAX", currencyCode)).get(0).getAmount();
        BigDecimal orderTotalPrice = this.getCartPriceInfo(new PriceFilter("ORDER", "TOTAL", currencyCode)).get(0).getAmount();
        orderNode.setProperty("jcr:language", this.getLocale().toString());
        orderNode.setProperty("currencyCode", currencyCode);
        orderNode.setProperty("cartSubtotal", cartPreTaxPrice);
        orderNode.setProperty("orderShipping", orderShipping);
        orderNode.setProperty("orderTotalTax", orderTotalTax);
        orderNode.setProperty("orderTotalPrice", orderTotalPrice);
        orderNode.setProperty("orderPlaced", placedTime);
        orderNode.setProperty("orderId", this.orderDetails.get(this.PN_ORDER_ID));
        Node orderDetailsNode = JcrUtil.createUniqueNode(orderNode, "order-details", "nt:unstructured", session);
        for (Map.Entry<String, String> entry : this.orderDetails.entrySet()) {
            String[] parts;
            String detail = this.serializeOrderDetail(entry.getKey(), entry.getValue());
            if (detail == null || (parts = detail.split("=")).length != 2) continue;
            orderDetailsNode.setProperty(parts[0], parts[1]);
        }
        ArrayList<String> infos = new ArrayList<String>();
        for (PromotionInfo promotionInfo : this.getPromotions()) {
            info = this.serializePromotionInfo(promotionInfo);
            if (info == null) continue;
            infos.add(info);
        }
        orderNode.setProperty("promotions", infos.toArray(new String[infos.size()]));
        infos = new ArrayList();
        for (VoucherInfo voucherInfo : this.getVoucherInfos()) {
            info = this.serializeVoucherInfo(voucherInfo);
            if (info == null) continue;
            infos.add(info);
        }
        orderNode.setProperty("vouchers", infos.toArray(new String[infos.size()]));
    }

    protected String serializeCartEntry(CommerceSession.CartEntry entry) throws CommerceException {
        return entry.getProduct().getPath() + ";" + entry.getQuantity();
    }

    protected String serializeOrderDetail(String key, String value) throws CommerceException {
        if (key.equals(this.PN_ORDER_ID)) {
            return null;
        }
        if (key.equals("payment.primary-account-number")) {
            if (value.length() > 4) {
                value = value.substring(0, value.length() - 4).replaceAll("[0-9]", "x") + value.substring(value.length() - 4);
            }
        } else if (key.equals("payment.ccv")) {
            return null;
        }
        return key + "=" + value;
    }

    protected String serializeVoucherInfo(VoucherInfo voucherInfo) {
        if (voucherInfo.getIsValid()) {
            return voucherInfo.getCode() + ";" + voucherInfo.getPath() + ";" + voucherInfo.getMessage();
        }
        return null;
    }

    protected String serializePromotionInfo(PromotionInfo promotionInfo) {
        if (promotionInfo.getStatus() == PromotionInfo.PromotionStatus.FIRED) {
            Integer entryIndex = promotionInfo.getCartEntryIndex();
            return promotionInfo.getPath() + ";" + entryIndex + ";" + promotionInfo.getMessage();
        }
        return null;
    }

    @Override
    public PlacedOrderResult getPlacedOrders(String predicate, int pageNumber, int pageSize, String sortId) throws CommerceException {
        ArrayList<PlacedOrder> orders = new ArrayList<PlacedOrder>();
        try {
            Session userSession = this.resolver.adaptTo(Session.class);
            UserProperties userProperties = (UserProperties)this.request.adaptTo(UserProperties.class);
            if (userProperties != null && !UserPropertiesUtil.isAnonymous(userProperties)) {
                UserManager um = ((JackrabbitSession)userSession).getUserManager();
                Authorizable user = um.getAuthorizable(userProperties.getAuthorizableID());
                StringBuilder buffer = new StringBuilder();
                buffer.append("/jcr:root").append(ISO9075.encodePath(user.getPath() + USER_ORDERS_PATH)).append("/element(*)[@orderId]");
                Query query = userSession.getWorkspace().getQueryManager().createQuery(buffer.toString(), "xpath");
                NodeIterator nodeIterator = query.execute().getNodes();
                Predicate filter = this.getPredicate(predicate);
                while (nodeIterator.hasNext()) {
                    DefaultJcrPlacedOrder order = this.newPlacedOrderImpl(nodeIterator.nextNode().getPath());
                    if (filter != null && !filter.evaluate((Object)order)) continue;
                    orders.add(order);
                }
            }
        }
        catch (Exception e) {
            log.error("Error while fetching orders", (Throwable)e);
        }
        return new PlacedOrderResult(orders, null, null);
    }

    protected Predicate getPredicate(String predicateName) {
        return null;
    }

    public DefaultJcrPlacedOrder newPlacedOrderImpl(String orderId) {
        return new DefaultJcrPlacedOrder(this, orderId);
    }

    @Override
    public PlacedOrder getPlacedOrder(String orderId) throws CommerceException {
        return this.newPlacedOrderImpl(orderId);
    }

    @Override
    @Deprecated
    public String getPriceInfo(Product product) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    @Override
    @Deprecated
    public String getCartPreTaxPrice() throws CommerceException {
        return this.getCartPrice(null);
    }

    @Override
    @Deprecated
    public String getCartTax() throws CommerceException {
        return this.getCartPrice(new PriceFilter("TAX"));
    }

    @Override
    @Deprecated
    public String getCartTotalPrice() throws CommerceException {
        return this.getCartPrice(new PriceFilter("POST_TAX"));
    }

    @Override
    @Deprecated
    public String getOrderShipping() throws CommerceException {
        return this.getCartPrice(new PriceFilter("SHIPPING"));
    }

    @Override
    @Deprecated
    public String getOrderTotalTax() throws CommerceException {
        return this.getCartPrice(new PriceFilter("ORDER", "TAX"));
    }

    @Override
    @Deprecated
    public String getOrderTotalPrice() throws CommerceException {
        return this.getCartPrice(new PriceFilter("ORDER"));
    }

    @Deprecated
    public String getShippingPrice(String method) {
        return new PriceInfo(this.getShipping(method), this.userLocale != null ? this.userLocale : this.locale).getFormattedString();
    }

    @Deprecated
    protected String formatPrice(BigDecimal price) {
        if (price == null) {
            return "";
        }
        return this.formatter.format(price.doubleValue());
    }

    @Override
    @Deprecated
    public List<Voucher> getVouchers() throws CommerceException {
        ArrayList<Voucher> vouchers = new ArrayList<Voucher>();
        for (Voucher voucher : this.vouchers) {
            vouchers.add(new AbstractJcrVoucher(this.resolver.getResource(voucher.getPath())));
        }
        return vouchers;
    }

    @Override
    @Deprecated
    public void updateOrderDetails(Map<String, String> delta) throws CommerceException {
        this.doUpdateOrderDetails(delta);
        this.saveCart();
    }

    @Override
    @Deprecated
    public void submitOrder(Map<String, String> orderDetailsDelta) throws CommerceException {
        this.doPlaceOrder(orderDetailsDelta);
    }
}

