/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.OrderHistoryTraitDataProvider;
import com.adobe.cq.commerce.api.PlacedOrderResult;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.common.AbstractJcrProduct;
import com.day.cq.commons.ImageResource;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommerceHelper {
    private static final Logger log = LoggerFactory.getLogger(CommerceHelper.class);

    public static String mapPathToCurrentLanguage(Page currentPage, String srcPath) {
        String[] pageParts = currentPage.getPath().split("/");
        Object[] srcParts = srcPath.split("/");
        if (pageParts.length > 4 && srcParts.length > 4 && pageParts[0].equals(srcParts[0]) && pageParts[1].equals(srcParts[1]) && pageParts[2].equals(srcParts[2])) {
            srcParts[3] = pageParts[3];
            return StringUtils.join((Object[])srcParts, (String)"/");
        }
        return srcPath;
    }

    public static Comparator<Product> getProductSizeComparator() {
        final String[] letterSizes = new String[]{"XXS", "2XS", "XS", "S", "M", "L", "XL", "XXL", "2XL", "XXXL", "3XL"};
        final String[] units = new String[]{"IN", "FT", "MM", "CM", "M"};
        return new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                String[] parts;
                String size1 = o1.getProperty("size", String.class).toUpperCase();
                String size2 = o2.getProperty("size", String.class).toUpperCase();
                if (CommerceHelper.indexOf(letterSizes, size1) >= 0 && CommerceHelper.indexOf(letterSizes, size2) >= 0) {
                    return NumberUtils.compare((float)CommerceHelper.indexOf(letterSizes, size1), (float)CommerceHelper.indexOf(letterSizes, size2));
                }
                for (String unit : units) {
                    if (!size1.contains(unit) || !size2.contains(unit)) continue;
                    size1 = size1.replace(unit, "");
                    size2 = size2.replace(unit, "");
                }
                if (size1.contains("\"")) {
                    size1 = size1.replace("\"", "");
                }
                if (size1.indexOf("'") >= 1) {
                    parts = size1.split("'");
                    size1 = parts[0];
                    size1 = parts.length == 1 ? size1 + "00" : (parts[1].length() == 1 ? size1 + "0" + parts[1] : size1 + parts[1]);
                }
                if (size2.contains("\"")) {
                    size2 = size2.replace("\"", "");
                }
                if (size2.indexOf("'") >= 1) {
                    parts = size2.split("'");
                    size2 = parts[0];
                    size2 = parts.length == 1 ? size2 + "00" : (parts[1].length() == 1 ? size2 + "0" + parts[1] : size2 + parts[1]);
                }
                if (!NumberUtils.isNumber((String)size1) || !NumberUtils.isNumber((String)size2)) {
                    throw new IllegalArgumentException(String.format("Size values not recognized: %s, %s", o1.getProperty("size", String.class), o2.getProperty("size", String.class)));
                }
                double d1 = Double.parseDouble(size1);
                double d2 = Double.parseDouble(size2);
                return NumberUtils.compare((double)d1, (double)d2);
            }
        };
    }

    private static int indexOf(String[] strings, String op) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(op)) continue;
            return i;
        }
        return -1;
    }

    public static Product findCurrentProduct(Page currentPage) {
        try {
            return CommerceHelper.findProduct(currentPage.getContentResource());
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected static Product findProduct(Resource resource) throws RepositoryException {
        Resource productResource = CommerceHelper.findProductResource(resource);
        if (productResource != null) {
            return productResource.adaptTo(Product.class);
        }
        return null;
    }

    public static Resource findProductResource(Page page) {
        return CommerceHelper.findProductResource(page.getContentResource());
    }

    public static Resource findProductResource(Resource resource) {
        if (AbstractJcrProduct.isABaseProduct(resource)) {
            return resource;
        }
        Iterator<Resource> iter = resource.listChildren();
        while (iter.hasNext()) {
            Resource product = CommerceHelper.findProductResource(iter.next());
            if (product == null) continue;
            return product;
        }
        return null;
    }

    public static void collectVariants(Resource resource, Map<String, Product> variations) {
        if (AbstractJcrProduct.isAProductOrVariant(resource)) {
            String key = ResourceUtil.getValueMap(resource).get("productData", "");
            variations.put(key, resource.adaptTo(Product.class));
        }
        Iterator<Resource> children = resource.listChildren();
        while (children.hasNext()) {
            CommerceHelper.collectVariants(children.next(), variations);
        }
    }

    public static boolean copyTags(Product source, Resource dest, Predicate filter) throws RepositoryException {
        String[] sourceTags;
        TagManager tagManager = dest.getResourceResolver().adaptTo(TagManager.class);
        ArrayList<String> resultTags = new ArrayList<String>();
        boolean changed = false;
        String[] destTags = (String[])ResourceUtil.getValueMap(dest).get("cq:tags", String[].class);
        if (destTags != null) {
            resultTags.addAll(Arrays.asList(destTags));
        }
        for (String sourceTag : sourceTags = source.getProperty("cq:tags", String[].class)) {
            Tag tag = tagManager.resolve(sourceTag);
            if (tag == null || !filter.evaluate((Object)tag) || resultTags.contains(sourceTag)) continue;
            resultTags.add(sourceTag);
            changed = true;
        }
        if (changed) {
            dest.adaptTo(Node.class).setProperty("cq:tags", resultTags.toArray(new String[resultTags.size()]));
        }
        return changed;
    }

    public static void writeCart(JSONWriter writer, CommerceSession commerceSession) throws CommerceException, JSONException {
        CommerceHelper.writeCart(writer, commerceSession, null);
    }

    public static void writeCart(JSONWriter writer, CommerceSession commerceSession, ResourceResolver resolver) throws CommerceException, JSONException {
        PromotionManager pm;
        writer.object();
        writer.key("entries").array();
        for (CommerceSession.CartEntry e : commerceSession.getCartEntries()) {
            writer.object();
            writer.key("title").value(e.getProduct().getTitle());
            writer.key("quantity").value(e.getQuantity());
            List<PriceInfo> priceInfos = e.getPriceInfo(null);
            if (priceInfos != null && priceInfos.size() > 0) {
                writer.key("priceFormatted").value(priceInfos.get(0).getFormattedString());
                writer.key("price").value(priceInfos.get(0).getAmount());
            } else {
                log.error("Empty PriceInfo list for product!", (Object)e.getProduct().getPath());
                writer.key("priceFormatted").value("$0.00");
                writer.key("price").value(0L);
            }
            ImageResource thumbnail = e.getProduct().getThumbnail();
            if (thumbnail != null) {
                thumbnail.setSelector(thumbnail.getSelector() + ".64.transparent");
                writer.key("thumbnail").value(thumbnail.getHref());
            }
            writer.key("page").value(e.getProduct().getPagePath());
            writer.key("path").value(e.getProduct().getPath());
            writer.endObject();
        }
        writer.endArray();
        HashSet<String> codes = new HashSet<String>();
        if (resolver != null && (pm = resolver.adaptTo(PromotionManager.class)) != null) {
            for (Promotion promo : pm.getAvailablePromotions(resolver)) {
                String code = promo.getConfig().get("code", "");
                if (!StringUtils.isNotBlank((String)code)) continue;
                codes.add(code);
            }
        }
        writer.key("promotions").array();
        for (PromotionInfo p : commerceSession.getPromotions()) {
            if (p.getStatus() != PromotionInfo.PromotionStatus.FIRED && p.getStatus() != PromotionInfo.PromotionStatus.POTENTIAL) continue;
            writer.object();
            writer.key("title").value(p.getTitle());
            writer.key("description").value(p.getDescription());
            writer.key("message").value(p.getMessage());
            writer.key("path").value(p.getPath());
            writer.key("status").value(p.getStatus().toString());
            writer.key("cartEntryIndex").value(p.getCartEntryIndex());
            if (p.getStatus().equals((Object)PromotionInfo.PromotionStatus.FIRED) && codes.contains(p.getPath())) {
                writer.key("resolve").value("true");
            }
            writer.endObject();
        }
        writer.endArray();
        writer.key("vouchers").array();
        for (VoucherInfo c : commerceSession.getVoucherInfos()) {
            writer.object();
            writer.key("code").value(c.getCode());
            writer.key("title").value(c.getTitle());
            writer.key("description").value(c.getDescription());
            writer.key("message").value(c.getMessage());
            writer.key("path").value(c.getPath());
            writer.endObject();
        }
        writer.endArray();
        List<PriceInfo> priceInfos = commerceSession.getCartPriceInfo(null);
        if (priceInfos != null && priceInfos.size() > 0) {
            writer.key("totalPrice").value(priceInfos.get(0).getFormattedString());
            writer.key("totalPriceFloat").value(priceInfos.get(0).getAmount());
        } else {
            log.error("Empty PriceInfo list for cart!");
            writer.key("totalPrice").value("$0.00");
            writer.key("totalPriceFloat").value(0L);
        }
        writer.endObject();
    }

    public static void writeOrderHistory(JSONWriter writer, PlacedOrderResult orderHistory, OrderHistoryTraitDataProvider[] services) throws CommerceException, JSONException {
        if (services == null) {
            services = new OrderHistoryTraitDataProvider[]{};
        }
        writer.object();
        writer.key("traits").object();
        Arrays.sort(services, new Comparator<OrderHistoryTraitDataProvider>(){

            @Override
            public int compare(OrderHistoryTraitDataProvider o1, OrderHistoryTraitDataProvider o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (OrderHistoryTraitDataProvider trait : services) {
            writer.key(trait.getIdentifier()).object();
            writer.key("name").value(trait.getName());
            writer.key("data");
            Object data = trait.getTraitData(orderHistory);
            if (data instanceof Map) {
                writer.object();
                Map map = (Map)data;
                for (Map.Entry entry : map.entrySet()) {
                    writer.key((String)entry.getKey());
                    writer.value(entry.getValue());
                }
                writer.endObject();
            } else if (data instanceof Collection) {
                writer.array();
                for (Object o : (Collection)data) {
                    writer.value(o);
                }
                writer.endArray();
            } else {
                writer.value(data);
            }
            writer.endObject();
        }
        writer.endObject();
        writer.endObject();
    }

    public static String getCatalogCardThumbnail(String contextPath, Resource resource, PageManager pageManager) {
        HierarchyNodeInheritanceValueMap blueprintProps;
        ValueMap properties = resource.adaptTo(ValueMap.class);
        Page templatePage = null;
        if (ResourceUtil.isA(resource, "commerce/components/catalog")) {
            blueprintProps = new HierarchyNodeInheritanceValueMap(resource);
            templatePage = pageManager.getPage(blueprintProps.getInherited("templates/catalog", ""));
        } else if (ResourceUtil.isA(resource, "commerce/components/section")) {
            blueprintProps = new HierarchyNodeInheritanceValueMap(resource);
            templatePage = pageManager.getPage(blueprintProps.getInherited("templates/section", ""));
        }
        if (templatePage != null) {
            String url = contextPath + templatePage.getPath() + ".thumb.319.319.png";
            Calendar lastMod = (Calendar)((Object)templatePage.getProperties().get("image/file/jcr:content/jcr:lastModified", Calendar.class));
            if (lastMod != null) {
                url = url + "?ck=" + lastMod.getTimeInMillis() / 1000L;
            }
            return url;
        }
        String coverUrl = (String)((Object)properties.get("coverUrl", String.class));
        if (coverUrl != null) {
            return coverUrl + ".thumb.319.319.png";
        }
        return contextPath + resource.getParent().getPath() + ".thumb.319.319.png";
    }

    public static String getCardTitle(Resource resource, PageManager pageManager) {
        String title = "";
        try {
            if (AbstractJcrProduct.isAProductOrVariant(resource)) {
                Node node = resource.adaptTo(Node.class);
                if (node.hasProperty("jcr:title")) {
                    return node.getProperty("jcr:title").getString();
                }
                title = node.getName();
                for (node = node.getParent(); node != null; node = node.getParent()) {
                    if (node.hasProperty("jcr:title")) {
                        title = node.getProperty("jcr:title").getString() + " / " + title;
                        return title;
                    }
                    title = node.getName() + " / " + title;
                }
                return title;
            }
            Page page = pageManager.getPage(resource.getPath());
            if (page != null) {
                return page.getTitle();
            }
            Node node = resource.adaptTo(Node.class);
            if (node.hasProperty("jcr:content/jcr:title")) {
                return node.getProperty("jcr:content/jcr:title").getString();
            }
            if (node.hasProperty("jcr:title")) {
                return node.getProperty("jcr:title").getString();
            }
            title = node.getName();
            if (title.matches("\\d+")) {
                node = node.getParent();
                while (node.getName().matches("\\d+")) {
                    title = node.getName() + "." + title;
                    node = node.getParent();
                }
            }
            return title;
        }
        catch (RepositoryException repositoryException) {
            return title;
        }
    }

    public static String getProductCardThumbnail(String contextPath, Product product) {
        ImageResource image = product.getThumbnail();
        if (image != null) {
            image.setSelector(".thumbnail.319");
            return contextPath + image.getHref();
        }
        return null;
    }
}

