/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common.promotion;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.common.CommerceHelper;
import com.adobe.cq.commerce.common.PriceFilter;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.PageManager;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Example promotion handler which applies cross-sell discounts"}), @Property(name="commerce.promotion.type", value={"/libs/commerce/components/promotion/perfectpartner"})})
public class PerfectPartnerPromotionHandler
implements PromotionHandler {
    private final Logger log = LoggerFactory.getLogger(PerfectPartnerPromotionHandler.class);
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    Map<String, PairingsCache> promoCache = new HashMap<String, PairingsCache>();

    private PriceInfo calcDiscount(CommerceSession.CartEntry cartEntry, String discountType, BigDecimal discountValue) throws CommerceException {
        BigDecimal discount = BigDecimal.ZERO;
        PriceInfo unitPrice = cartEntry.getPriceInfo(new PriceFilter("UNIT")).get(0);
        if (discountType.equals("percentage")) {
            discount = discount.add(unitPrice.getAmount().multiply(discountValue.divide(new BigDecimal(100.0))));
        } else if (discountType.equals("absolute")) {
            discount = discount.add(discountValue);
        }
        discount = discount.multiply(new BigDecimal(cartEntry.getQuantity()));
        return new PriceInfo(discount, unitPrice.getLocale());
    }

    @Override
    public synchronized PriceInfo applyCartEntryPromotion(CommerceSession commerceSession, Promotion promotion, CommerceSession.CartEntry cartEntry) throws CommerceException {
        ValueMap config = promotion.getConfig();
        String discountType = config.get("discountType", "");
        BigDecimal discountValue = config.get("discountValue", BigDecimal.ZERO);
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        if (this.promoCache.get(promoPath).getCompanion(cartEntry.getProduct(), commerceSession) != null) {
            return this.calcDiscount(cartEntry, discountType, discountValue);
        }
        return null;
    }

    @Override
    public PriceInfo applyOrderPromotion(CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        return null;
    }

    @Override
    public PriceInfo applyShippingPromotion(CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        return null;
    }

    @Override
    @Deprecated
    public synchronized String getMessage(SlingHttpServletRequest request, CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        return this.getDescription(request, commerceSession, promotion);
    }

    @Override
    public synchronized String getDescription(SlingHttpServletRequest request, CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        Product product2;
        Product product1;
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        PairingsCache pairingCache = this.promoCache.get(promoPath);
        ArrayList<String> resolved = new ArrayList<String>();
        HashMap<String, String> potentials = new HashMap<String, String>();
        pairingCache.characterizeCart(commerceSession, resolved, potentials);
        PageManager pageManager = request.getResourceResolver().adaptTo(PageManager.class);
        I18n i18n = new I18n(request);
        String description = "";
        for (String pathSet : resolved) {
            if (description.length() > 0) {
                description = description + "<br>";
            }
            try {
                String[] paths = pathSet.split(";");
                product1 = CommerceHelper.findCurrentProduct(pageManager.getPage(paths[0]));
                product2 = CommerceHelper.findCurrentProduct(pageManager.getPage(paths[1]));
                description = description + product1.getTitle() + " + " + product2.getTitle();
            }
            catch (Exception e) {
                description = description + i18n.get("error fetching products");
            }
        }
        for (String path1 : potentials.keySet()) {
            if (description.length() > 0) {
                description = description + "<br>";
            }
            try {
                String path2 = (String)potentials.get(path1);
                product1 = CommerceHelper.findCurrentProduct(pageManager.getPage(path1));
                product2 = CommerceHelper.findCurrentProduct(pageManager.getPage(path2));
                description = description + i18n.get("{0} <span class='cq-cc-cart-potential-match'> (suggest {1})</span>", null, product1.getTitle(), product2.getTitle());
            }
            catch (Exception e) {
                description = description + i18n.get("error fetching products");
            }
        }
        if (description.length() == 0) {
            description = i18n.get("no pairings in cart");
        }
        return description;
    }

    @Override
    public synchronized Map<Integer, String> getMessages(SlingHttpServletRequest request, CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        HashMap<Integer, String> messages = new HashMap<Integer, String>();
        ValueMap config = promotion.getConfig();
        String discountType = config.get("discountType", "");
        BigDecimal discountValue = config.get("discountValue", BigDecimal.ZERO);
        String messageTemplate = (String)((Object)config.get("message", String.class));
        if (messageTemplate == null) {
            return messages;
        }
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        PairingsCache pairingCache = this.promoCache.get(promoPath);
        I18n i18n = new I18n(request);
        PageManager pageManager = request.getResourceResolver().adaptTo(PageManager.class);
        for (CommerceSession.CartEntry entry : commerceSession.getCartEntries()) {
            String companionTitle;
            Product product = entry.getProduct();
            String companionPath = pairingCache.getCompanion(product, commerceSession);
            if (companionPath == null) continue;
            try {
                Product companion = CommerceHelper.findCurrentProduct(pageManager.getPage(companionPath));
                companionTitle = companion.getTitle();
            }
            catch (Exception e) {
                companionTitle = i18n.get("unknown product");
            }
            PriceInfo discount = this.calcDiscount(entry, discountType, discountValue);
            messages.put(entry.getEntryIndex(), MessageFormat.format(messageTemplate, "", companionTitle, discount.getFormattedString()));
        }
        return messages;
    }

    public synchronized void getPotentials(CommerceSession commerceSession, Promotion promotion, Map<String, String> potentials) throws CommerceException {
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        PairingsCache pairingCache = this.promoCache.get(promoPath);
        ArrayList<String> resolved = new ArrayList<String>();
        pairingCache.characterizeCart(commerceSession, resolved, potentials);
    }

    @Override
    public synchronized void invalidateCaches() {
        this.promoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void validateCache(String promoPath) {
        if (!this.promoCache.containsKey(promoPath)) {
            ResourceResolver adminResolver = null;
            try {
                PairingsCache pairingsCache = new PairingsCache();
                this.promoCache.put(promoPath, pairingsCache);
                adminResolver = this.resolverFactory.getAdministrativeResourceResolver(Collections.<String, Object>emptyMap());
                Resource promoResource = adminResolver.getResource(promoPath);
                Resource pairings = promoResource.getChild("jcr:content").getChild("config").getChild("pairings");
                Iterator<Resource> iterator = pairings.listChildren();
                while (iterator.hasNext()) {
                    ValueMap pair = ResourceUtil.getValueMap(iterator.next());
                    pairingsCache.addPairing((String)((Object)pair.get("firstProductPath", String.class)), (String)((Object)pair.get("secondProductPath", String.class)));
                }
            }
            catch (Exception e) {
                this.log.error("Couldn't construct promotion cache for: " + promoPath, (Throwable)e);
            }
            finally {
                if (adminResolver != null && adminResolver.isLive()) {
                    adminResolver.close();
                }
            }
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    private class PairingsCache {
        private Map<String, List<String>> firstProductMap = new HashMap<String, List<String>>();
        private Map<String, List<String>> secondProductMap = new HashMap<String, List<String>>();

        private PairingsCache() {
        }

        public void addPairing(String firstProductPath, String secondProductPath) {
            if (firstProductPath == null || secondProductPath == null) {
                return;
            }
            if (this.firstProductMap.containsKey(firstProductPath)) {
                this.firstProductMap.get(firstProductPath).add(secondProductPath);
            } else {
                ArrayList<String> secondProductList = new ArrayList<String>();
                secondProductList.add(secondProductPath);
                this.firstProductMap.put(firstProductPath, secondProductList);
            }
            if (this.secondProductMap.containsKey(secondProductPath)) {
                this.secondProductMap.get(secondProductPath).add(firstProductPath);
            } else {
                ArrayList<String> firstProductList = new ArrayList<String>();
                firstProductList.add(firstProductPath);
                this.secondProductMap.put(secondProductPath, firstProductList);
            }
        }

        public String getCompanion(Product product, CommerceSession commerceSession) throws CommerceException {
            String secondProductPath = this.getProductPagePath(product);
            if (this.secondProductMap.containsKey(secondProductPath)) {
                List<String> firstProductList = this.secondProductMap.get(secondProductPath);
                for (String firstProductPath : firstProductList) {
                    if (!this.productInCart(firstProductPath, commerceSession)) continue;
                    return firstProductPath;
                }
            }
            return null;
        }

        public void characterizeCart(CommerceSession commerceSession, List<String> resolved, Map<String, String> potentials) throws CommerceException {
            for (CommerceSession.CartEntry entry : commerceSession.getCartEntries()) {
                String firstProductPath = this.getProductPagePath(entry.getProduct());
                if (!this.firstProductMap.containsKey(firstProductPath)) continue;
                List<String> secondProductsList = this.firstProductMap.get(firstProductPath);
                boolean match = false;
                for (String secondProductPath : secondProductsList) {
                    if (!this.productInCart(secondProductPath, commerceSession)) continue;
                    resolved.add(firstProductPath + ";" + secondProductPath);
                    match = true;
                }
                if (match) continue;
                potentials.put(firstProductPath, secondProductsList.get(0));
            }
        }

        private String getProductPagePath(Product product) {
            String href = product.getPagePath();
            int extension = href.indexOf(".html");
            if (extension > 0) {
                return href.substring(0, extension);
            }
            int fragment = href.indexOf(35);
            if (fragment > 0) {
                return href.substring(0, fragment);
            }
            return href;
        }

        private boolean productInCart(String productPath, CommerceSession commerceSession) throws CommerceException {
            for (CommerceSession.CartEntry entry : commerceSession.getCartEntries()) {
                if (!this.getProductPagePath(entry.getProduct()).equals(productPath)) continue;
                return true;
            }
            return false;
        }
    }
}

