/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mcm.salesforce;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%sf.configuration.name", description="%sf.configuration.description", metatype=true)
@Service(value={SalesforceConfiguration.class})
public class SalesforceConfiguration {
    private static final String DEFAULT_FIRSTNAME_MAPPING = "givenName=FirstName";
    private static final String DEFAULT_TITLE_MAPPING = "title=Title";
    private static final String DEFAULT_LASTNAME_MAPPING = "familyName=LastName";
    private static final String DEFAULT_EMAIL_MAPPING = "email=Email";
    private static final String DEFAULT_COMPANY_MAPPING = "company=Company";
    private static final String DEFAULT_PHONE_MAPPING = "phoneNumber=Phone";
    private static final String DEFAULT_MOBILE_MAPPING = "mobile=MobilePhone";
    private static final String DEFAULT_FAX_MAPPING = "fax=Fax";
    private static final String DEFAULT_WEBSITE_MAPPING = "website=Website";
    private static final String DEFAULT_LEAD_SOURCE_MAPPING = "source=LeadSource";
    private static final String DEFAULT_ANNUAL_REVENUE_MAPPING = "annualRevenue=AnnualRevenue";
    private static final String DEFAULT_STATUS_MAPPING = "status=Status";
    private static final String DEFAULT_RATING_MAPPING = "rating=Rating";
    private static final String DEFAULT_COUNT_EMP_MAPPING = "numberOfEmployees=NumberOfEmployees";
    private static final String DEFAULT_PROD_INTEREST_MAPPING = "productInterest=ProductInterest__c";
    private static final String DEFAULT_POSTALCODE_MAPPING = "postalCode=PostalCode";
    private static final String DEFAULT_CITY_MAPPING = "city=City";
    private static final String DEFAULT_STREET_MAPPING = "street=Street";
    private static final String DEFAULT_STATE_MAPPING = "state=State";
    private static final String DEFAULT_COUNTRY_MAPPING = "country=Country";
    private static final String DEFAULT_INDUSTRY_MAPPING = "industry=Industry";
    @Property(value={"givenName=FirstName", "title=Title", "familyName=LastName", "email=Email", "company=Company", "phoneNumber=Phone", "mobile=MobilePhone", "fax=Fax", "website=Website", "source=LeadSource", "annualRevenue=AnnualRevenue", "state=State", "status=Status", "rating=Rating", "numberOfEmployees=NumberOfEmployees", "productInterest=ProductInterest__c", "postalCode=PostalCode", "city=City", "street=Street", "country=Country", "industry=Industry"})
    private static final String DEFAULT_LEAD_MAPPING = "sf.lead.mapping";
    private Map<String, String> leadsMapping = new HashMap<String, String>();
    private static final Logger log = LoggerFactory.getLogger(SalesforceConfiguration.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            String[] mappings = OsgiUtil.toStringArray(context.getProperties().get(DEFAULT_LEAD_MAPPING));
            if (mappings != null) {
                for (int i = 0; i < mappings.length; ++i) {
                    String[] map = mappings[i].split("=");
                    this.leadsMapping.put(map[0], map[1]);
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to Parse Salesforce Configuration. Exception: " + e.getMessage());
        }
    }

    public Map<String, String> getLeadsMapping() {
        return this.leadsMapping;
    }
}

