/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mcm.salesforce;

import com.adobe.cq.mcm.salesforce.SalesforceClient;
import com.adobe.cq.mcm.salesforce.SalesforceConfiguration;
import com.adobe.cq.mcm.salesforce.SalesforceException;
import com.adobe.cq.mcm.salesforce.SalesforceResponse;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Export Leads to Salesforce"})
public class SalesforceExportProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SalesforceExportProcess.class);
    public static final String INSTANCE_URL = "instanceurl";
    public static final String ACCESS_TOKEN = "accesstoken";
    public static final String CUSTOMER_KEY = "customerkey";
    public static final String CUSTOMER_SECRET = "customersecret";
    public static final String REFRESH_TOKEN = "refreshtoken";
    public static final String JCR_PATH = "JCR_PATH";
    public static final String CQ_CLOUDSERVICECONFIG = "cq:cloudserviceconfig";
    public static final String SF_LEAD_MGMT_RESTFUL_PATH = "/services/data/v20.0/sobjects/Lead/";
    public static final String APPLICATION_JSON = "application/json";
    public static final String HTTP_PATCH = "PATCH";
    public static final String HTTP_POST = "POST";
    public static final int SF_SUCCESS_UPDATE_CODE = 204;
    private static final String SF_ENTITY_DELETED_ERRORCODE = "ENTITY_IS_DELETED";
    private static final String SF_REQUIRED_FIELD_MISSING_ERRORCODE = "REQUIRED_FIELD_MISSING";
    public static final String ERROR_CODE = "errorCode";
    public static final String SF_LEAD_CREATION_SUCCESS = "success";
    public static final String SF_LEAD_ID_FIELDNAME = "leadID";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private SalesforceConfiguration salesforceConfiguration;
    @Reference
    private CryptoSupport cryptoSupport;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block24: {
            Configuration salesforceConfig;
            String configPath;
            WorkflowData workflowData = workItem.getWorkflowData();
            if (workflowData.getPayloadType().equals(JCR_PATH) && this.configurationManager != null && (configPath = (String)((Object)args.get(CQ_CLOUDSERVICECONFIG, String.class))) != null && (salesforceConfig = this.configurationManager.getConfiguration(configPath)) != null) {
                Session session = workflowSession.getSession();
                String workflowPayloadPath = workItem.getWorkflowData().getPayload().toString();
                try {
                    if (session.itemExists(workflowPayloadPath)) {
                        Node node = session.getNode(workflowPayloadPath);
                        String instanceUrl = salesforceConfig.get(INSTANCE_URL, "");
                        String accessToken = salesforceConfig.get(ACCESS_TOKEN, "");
                        String clientId = salesforceConfig.get(CUSTOMER_KEY, "");
                        String encryptedCustomerSecret = salesforceConfig.get(CUSTOMER_SECRET, "");
                        String encryptedRefereshToken = salesforceConfig.get(REFRESH_TOKEN, "");
                        String customerSecret = encryptedCustomerSecret;
                        String refreshToken = encryptedRefereshToken;
                        if (this.cryptoSupport.isProtected(encryptedCustomerSecret)) {
                            customerSecret = this.cryptoSupport.unprotect(encryptedCustomerSecret);
                        }
                        if (this.cryptoSupport.isProtected(encryptedRefereshToken)) {
                            refreshToken = this.cryptoSupport.unprotect(encryptedRefereshToken);
                        }
                        Map<String, String> fieldsMapping = this.salesforceConfiguration.getLeadsMapping();
                        HashMap<String, String> httpData = new HashMap<String, String>();
                        for (Map.Entry<String, String> entry : fieldsMapping.entrySet()) {
                            if (!node.hasProperty(entry.getKey())) continue;
                            String fieldValue = node.getProperty(entry.getKey()).getValue().getString();
                            httpData.put(entry.getValue(), fieldValue);
                        }
                        JSONObject requestData = new JSONObject(httpData);
                        String requestDataString = requestData.toString();
                        SalesforceClient salesforceClient = new SalesforceClient();
                        salesforceClient.setAccessToken(accessToken);
                        salesforceClient.setRefreshToken(refreshToken);
                        salesforceClient.setClientId(clientId);
                        salesforceClient.setClientSecret(customerSecret);
                        salesforceClient.setInstanceURL(instanceUrl);
                        salesforceClient.setContentType(APPLICATION_JSON);
                        StringBuilder salesforcePath = new StringBuilder(SF_LEAD_MGMT_RESTFUL_PATH);
                        if (node.hasProperty(SF_LEAD_ID_FIELDNAME)) {
                            salesforcePath.append(node.getProperty(SF_LEAD_ID_FIELDNAME).getValue().getString());
                            salesforceClient.setStringMethod(HTTP_PATCH);
                        } else {
                            salesforceClient.setStringMethod(HTTP_POST);
                        }
                        salesforceClient.setPath(salesforcePath.toString());
                        salesforceClient.setData(requestDataString);
                        SalesforceResponse salesforceResponse = salesforceClient.executeRequest();
                        if (salesforceResponse.getAccessTokenUpdated().booleanValue()) {
                            Node configNode = session.getNode(configPath).getNode("jcr:content");
                            configNode.setProperty(ACCESS_TOKEN, salesforceClient.getAccessToken());
                            configNode.getSession().save();
                        }
                        try {
                            if (salesforceResponse.getBody() == null && salesforceResponse.getCode() == 204) {
                                log.info("Salesforce Lead Updated with Success (id: " + node.getProperty(SF_LEAD_ID_FIELDNAME).getValue().getString() + ")");
                            } else {
                                JSONObject responseJson = salesforceResponse.getBodyAsJSON();
                                if (responseJson.has(SF_LEAD_CREATION_SUCCESS) && responseJson.getBoolean(SF_LEAD_CREATION_SUCCESS)) {
                                    if (!node.hasProperty(SF_LEAD_ID_FIELDNAME)) {
                                        node.setProperty(SF_LEAD_ID_FIELDNAME, responseJson.getString("id"));
                                        session.save();
                                        log.info("New Salesforce Lead Created with Success (id: " + responseJson.getString("id") + ")");
                                    }
                                } else if (responseJson.has(ERROR_CODE) && responseJson.getString(ERROR_CODE) != null) {
                                    String errorCode = responseJson.getString(ERROR_CODE);
                                    if (SF_ENTITY_DELETED_ERRORCODE.equals(errorCode)) {
                                        Boolean recreateLeadFlag = (Boolean)((Object)args.get("recreateLead", Boolean.class));
                                        if (recreateLeadFlag != null && recreateLeadFlag.equals(true)) {
                                            salesforceClient.setPath(SF_LEAD_MGMT_RESTFUL_PATH);
                                            salesforceClient.setStringMethod(HTTP_POST);
                                            salesforceResponse = salesforceClient.executeRequest();
                                            responseJson = salesforceResponse.getBodyAsJSON();
                                            node.setProperty(SF_LEAD_ID_FIELDNAME, responseJson.getString("id"));
                                            session.save();
                                            log.info("Salesforce Lead Created again (after deletion from SF) with Success (id: " + responseJson.getString("id") + ")");
                                        }
                                    } else if (SF_REQUIRED_FIELD_MISSING_ERRORCODE.equals(errorCode)) {
                                        log.error("Lead Creation failed. Some required fields missing while creating lead: " + salesforceResponse.getBody());
                                        throw new SalesforceException("Lead Creation failed. Some required fields missing while creating lead: " + salesforceResponse.getBody());
                                    }
                                }
                            }
                            break block24;
                        }
                        catch (JSONException e) {
                            log.error("JSON Exception while parsing Response from Salesforce in Lead creation/updation workflow. Response: " + salesforceResponse.getBody());
                        }
                        break block24;
                    }
                    log.error("Salesforce node could not be found. path: " + workflowPayloadPath);
                    throw new WorkflowException("Salesforce node could not be found. path: " + workflowPayloadPath);
                }
                catch (RepositoryException re) {
                    log.error("Repository Exception in Lead Creation Workflow " + re.getMessage());
                    throw new WorkflowException("Repository Exception in Lead Creation Workflow " + re.getMessage());
                }
                catch (CryptoException e) {
                    log.error("Crypto Exception in Lead Creation Workflow: " + e.getMessage());
                    throw new WorkflowException("Crypto Exception in Lead Creation Workflow: " + e.getMessage());
                }
                catch (SalesforceException se) {
                    log.error("Exception while Publishing lead to Salesforce: " + se.getMessage());
                    throw new WorkflowException("Exception while Publishing lead to Salesforce: " + se.getMessage());
                }
            }
        }
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindSalesforceConfiguration(SalesforceConfiguration salesforceConfiguration) {
        this.salesforceConfiguration = salesforceConfiguration;
    }

    protected void unbindSalesforceConfiguration(SalesforceConfiguration salesforceConfiguration) {
        if (this.salesforceConfiguration == salesforceConfiguration) {
            this.salesforceConfiguration = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

