/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mcm.salesforce;

import com.adobe.cq.mcm.salesforce.SalesforceClient;
import com.adobe.cq.mcm.salesforce.SalesforceException;
import com.adobe.cq.mcm.salesforce.SalesforceResponse;
import com.adobe.cq.mcm.salesforce.SalesforceSearchParameters;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.wcm.webservicesupport.Configuration;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SalesforceLeadSearch.class})
public class SalesforceLeadSearch {
    private static final Logger log = LoggerFactory.getLogger(SalesforceLeadSearch.class);
    private static final String INSTANCE_URL = "instanceurl";
    public static final String CUSTOMER_KEY = "customerkey";
    public static final String CUSTOMER_SECRET = "customersecret";
    public static final String REFRESH_TOKEN = "refreshtoken";
    private static final String QUERY_PATH = "/services/data/v20.0/query/";
    public static final String APPLICATION_JSON = "application/json";
    public static final String ACCESS_TOKEN = "accesstoken";
    @Reference
    private CryptoSupport cryptoSupport;

    public JSONObject search(Configuration cloudConfig, SalesforceSearchParameters parameters, ResourceResolver resolver) throws SalesforceException {
        if (cloudConfig != null) {
            String instanceUrl = cloudConfig.get(INSTANCE_URL, "");
            String accessToken = cloudConfig.get(ACCESS_TOKEN, "");
            String clientId = cloudConfig.get(CUSTOMER_KEY, "");
            String encryptedCustomerSecret = cloudConfig.get(CUSTOMER_SECRET, "");
            String encryptedRefereshToken = cloudConfig.get(REFRESH_TOKEN, "");
            try {
                String customerSecret = encryptedCustomerSecret;
                String refreshToken = encryptedRefereshToken;
                if (this.cryptoSupport.isProtected(encryptedCustomerSecret)) {
                    customerSecret = this.cryptoSupport.unprotect(encryptedCustomerSecret);
                }
                if (this.cryptoSupport.isProtected(encryptedRefereshToken)) {
                    refreshToken = this.cryptoSupport.unprotect(encryptedRefereshToken);
                }
                SalesforceClient client = new SalesforceClient();
                client.setAccessToken(accessToken);
                client.setInstanceURL(instanceUrl);
                client.setRefreshToken(refreshToken);
                client.setClientId(clientId);
                client.setClientSecret(customerSecret);
                client.setMethod(SalesforceClient.AvailableMethods.GET);
                client.setContentType(APPLICATION_JSON);
                client.setPath(QUERY_PATH);
                client.addParameter("q", this.buildSOSL(parameters));
                SalesforceResponse response = client.executeRequest();
                if (response.getAccessTokenUpdated().booleanValue()) {
                    String configPath = cloudConfig.getPath();
                    Resource configResource = resolver.getResource(configPath);
                    Node configNode = configResource.adaptTo(Node.class).getNode("jcr:content");
                    configNode.setProperty(ACCESS_TOKEN, client.getAccessToken());
                    configNode.getSession().save();
                }
                return response.getBodyAsJSON();
            }
            catch (RepositoryException e) {
                log.error("Repository Exception in Searching SFDC Leads " + e.getMessage());
                throw new SalesforceException("Repository Exception in Searching SFDC Leads " + e.getMessage());
            }
            catch (CryptoException e) {
                log.error("Cryto Exception in searching SFDC Leads " + e.getMessage());
                throw new SalesforceException("Crypto Exception in searching SFDC Leads " + e.getMessage());
            }
            catch (JSONException e) {
                log.error("JSON Exception in searching SFDC Leads " + e.getMessage());
                throw new SalesforceException("JSON Exception in searching SFDC Leads " + e.getMessage());
            }
        }
        return null;
    }

    protected String buildSOSL(SalesforceSearchParameters parameters) throws SalesforceException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        if (parameters.getResultProperties() != null && parameters.getResultProperties().length > 0) {
            for (int i = 0; i < parameters.getResultProperties().length; ++i) {
                if (parameters.getResultProperties()[i] == null) continue;
                query.append(parameters.getResultProperties()[i] + ", ");
            }
            query.deleteCharAt(query.lastIndexOf(","));
        } else {
            query.append("FirstName, LastName, Company, Status, Email ");
        }
        if (SalesforceSearchParameters.SalesforceObjectType.LEAD.equals((Object)parameters.getObjectType())) {
            query.append("FROM LEAD ");
        } else if (SalesforceSearchParameters.SalesforceObjectType.CONTACT.equals((Object)parameters.getObjectType())) {
            query.append("FROM CONTACT ");
        } else {
            throw new SalesforceException("Invalid Search Query: Must search for either Leads or Contacts");
        }
        if (parameters.getSearchOperator() != null && parameters.getSearchType() != null && parameters.getSearchVal() != null) {
            query.append("WHERE " + parameters.getSearchType() + " " + parameters.getSearchOperator() + " " + this.getEncodedSearchVal(parameters.getSearchOperator(), parameters.getSearchVal()));
        }
        return query.toString();
    }

    private String getEncodedSearchVal(String operator, String searchVal) {
        Double searchValue = null;
        try {
            searchValue = Double.parseDouble(searchVal);
            return searchValue.toString();
        }
        catch (NumberFormatException e) {
            return "'" + searchVal + "'";
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

