/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.mobile.angular.data.util;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkContentExporterUtils {
    public static final String NG_PAGE_RESOURCE_TYPE = "mobileapps/components/angular/ng-page";
    public static final String NG_REDIRECT_RESOURCE_TYPE = "foundation/components/redirect";
    public static final String NG_FRAMEWORK_TYPE_ID = "angular";
    private static final String JCR_CONTENT = "jcr:content/";

    public static String getRelativePathToDescendantResource(Resource parentResource, Resource descendantResource) {
        return FrameworkContentExporterUtils.getRelativePathToDescendantPath(parentResource, descendantResource.getPath());
    }

    public static String getRelativePathToDescendantPath(Resource parentResource, String absoluteDescendantPath) {
        String parentPath = parentResource.getPath();
        if (absoluteDescendantPath.indexOf(parentPath) == 0) {
            String relativeResourcePath = parentResource.getName() + absoluteDescendantPath.substring(parentPath.length());
            return relativeResourcePath;
        }
        return null;
    }

    public static String getPathToAsset(Resource parentResource, String absoluteDescendantAssetPath, boolean appExport) {
        if (!appExport) {
            return absoluteDescendantAssetPath;
        }
        String relativeResourcePath = FrameworkContentExporterUtils.getRelativePathToDescendantPath(parentResource, absoluteDescendantAssetPath);
        relativeResourcePath = FrameworkContentExporterUtils.replaceJcrContent(relativeResourcePath);
        return relativeResourcePath;
    }

    public static Resource getTopLevelAppResource(Resource resource) {
        Resource parent = resource.getParent();
        if (parent == null || !"cq:Page".equals(parent.getResourceType())) {
            return resource;
        }
        Resource parentContentResource = parent.getChild("jcr:content");
        if (parentContentResource != null && parentContentResource.isResourceType(NG_REDIRECT_RESOURCE_TYPE)) {
            return resource;
        }
        return FrameworkContentExporterUtils.getTopLevelAppResource(parent);
    }

    public static boolean isTopLevelAppResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource.equals(FrameworkContentExporterUtils.getTopLevelAppResource(resource));
    }

    public static long getMillisecondsSinceUnixEpoch() {
        return System.currentTimeMillis();
    }

    public static List<Page> getAllAngularDescendantPages(Page page, PageFilter pageFilter) {
        ArrayList<Page> pageList = new ArrayList<Page>();
        FrameworkContentExporterUtils.getAllDescendantsOfResourceType(page, NG_PAGE_RESOURCE_TYPE, pageFilter, pageList);
        return pageList;
    }

    public static String getJsFriendlyResourceName(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        String uniqueName = resourcePath;
        String key = JCR_CONTENT;
        int indexOfKey = uniqueName.indexOf(key);
        if (indexOfKey > 0) {
            uniqueName = uniqueName.substring(indexOfKey + key.length());
        }
        return uniqueName.replaceAll("[^A-Za-z0-9]", "");
    }

    public static String getRelativePathToRootLevel(Resource resource) {
        String path = "";
        Resource ancestor = resource.getParent();
        while ((ancestor = ancestor.getParent()) != null) {
            path = path + "../";
        }
        return path;
    }

    public static List<Resource> getAllAngularPageComponents(Resource pageContentResource) {
        ArrayList<Resource> angularComponents = new ArrayList<Resource>();
        FrameworkContentExporterUtils.getAllAngularPageComponentsHelper(pageContentResource, angularComponents);
        return angularComponents;
    }

    public static Resource getAncestorTemplateResource(Resource resource, String resourceType) {
        if (resource == null || resourceType == null) {
            return null;
        }
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource != null && contentResource.isResourceType(resourceType)) {
            return resource;
        }
        return FrameworkContentExporterUtils.getAncestorTemplateResource(resource.getParent(), resourceType);
    }

    public static String getRelativeComponentPath(String path) {
        if (path == null || !path.contains(JCR_CONTENT)) {
            return path;
        }
        return path.substring(path.indexOf(JCR_CONTENT) + JCR_CONTENT.length());
    }

    private static void getAllAngularPageComponentsHelper(Resource resource, List<Resource> components) {
        Iterator<Resource> resourceChildrenIter = resource.listChildren();
        while (resourceChildrenIter.hasNext()) {
            Resource childResource = resourceChildrenIter.next();
            ValueMap childProperties = childResource.adaptTo(ValueMap.class);
            if (NG_FRAMEWORK_TYPE_ID.equals(childProperties.get("frameworkType", String.class))) {
                components.add(childResource);
            }
            FrameworkContentExporterUtils.getAllAngularPageComponentsHelper(childResource, components);
        }
    }

    private static void getAllDescendantsOfResourceType(Page page, String resourceType, PageFilter pageFilter, List<Page> list) {
        Iterator<Page> children = page.listChildren(pageFilter, true);
        while (children.hasNext()) {
            Page child = children.next();
            Resource contentResource = child.getContentResource();
            if (contentResource == null || !contentResource.isResourceType(resourceType)) continue;
            list.add(child);
        }
    }

    private static String replaceJcrContent(String path) {
        if (path == null) {
            return null;
        }
        return path.replaceAll("/jcr:content/", "/jcr_content/");
    }
}

