/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.searchcollections.lucene;

import java.io.IOException;
import javax.jcr.Session;
import javax.jcr.lock.LockManager;
import org.apache.lucene.store.Lock;

public class JCRLock
extends Lock {
    private final Session session;
    private final String path;

    JCRLock(Session session, String path) {
        this.session = session;
        this.path = path;
    }

    public boolean obtain() throws IOException {
        try {
            LockManager lm = this.session.getWorkspace().getLockManager();
            lm.lock(this.path, true, true, 0L, "JCRLockFactory");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    public void release() throws IOException {
        try {
            LockManager lm = this.session.getWorkspace().getLockManager();
            lm.unlock(this.path);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean isLocked() throws IOException {
        try {
            LockManager lm = this.session.getWorkspace().getLockManager();
            return lm.holdsLock(this.path);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

