/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sightly;

import com.adobe.cq.sightly.SightlyWCMMode;
import com.adobe.cq.sightly.WCMResourceOptions;
import com.adobe.cq.sightly.internal.PrintWriterResponseWrapper;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.IncludeOptions;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCMScriptHelper {
    private final Logger log = LoggerFactory.getLogger(WCMScriptHelper.class);
    private SlingScriptHelper slingHelper;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private SightlyWCMMode mode;

    public WCMScriptHelper(SlingScriptHelper sling) {
        this.slingHelper = sling;
        this.request = sling.getRequest();
        this.response = sling.getResponse();
        this.mode = new SightlyWCMMode(this.request);
    }

    public void includeResource(PrintWriter out, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        PrintWriterResponseWrapper customResponse = new PrintWriterResponseWrapper(out, this.response);
        this.includeResource((SlingHttpServletResponse)customResponse, script, dispatcherOptions, resourceType, wcmResourceOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeResource(SlingHttpServletResponse customResponse, String script, String dispatcherOptions, String resourceType, WCMResourceOptions wcmResourceOptions) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            this.log.error("Script path cannot be empty");
        } else {
            script = this.normalizePath(script);
            Resource includeRes = this.request.getResourceResolver().resolve(script);
            if (includeRes instanceof NonExistingResource || includeRes.isResourceType("sling:nonexisting")) {
                includeRes = new SyntheticResource(this.request.getResourceResolver(), script, resourceType);
            }
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            try {
                WCMMode mode = wcmResourceOptions.getWCMMode();
                if (mode != null) {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
                }
                IncludeOptions includeOptions = IncludeOptions.getOptions((ServletRequest)this.request, true);
                String decorationTag = wcmResourceOptions.getDecorationTagName();
                if (decorationTag == null) {
                    ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.request);
                    decorationTag = componentContext.getDecorationTagName();
                }
                includeOptions.setDecorationTagName(decorationTag);
                String cssClassName = wcmResourceOptions.getCssClassName();
                if (StringUtils.isNotEmpty((CharSequence)cssClassName)) {
                    includeOptions.getCssClassNames().add(cssClassName);
                }
                RequestDispatcherOptions opts = new RequestDispatcherOptions(dispatcherOptions);
                if (StringUtils.isNotEmpty((CharSequence)resourceType)) {
                    opts.setForceResourceType(resourceType);
                }
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(includeRes, opts);
                dispatcher.include((ServletRequest)this.request, (ServletResponse)customResponse);
            }
            catch (Exception e) {
                this.log.error("Failed to include resource {}", (Object)script, (Object)e);
            }
            finally {
                if (currentMode == null) {
                    this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
                } else {
                    this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
                }
            }
        }
    }

    public void includeScript(String script, String wcmMode, PrintWriter out) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            this.log.error("Script path cannot be empty");
        } else {
            ServletResolver servletResolver;
            WCMMode mode;
            WCMMode currentMode = (WCMMode)((Object)this.request.getAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME));
            if (StringUtils.isNotEmpty((CharSequence)wcmMode) && (mode = WCMMode.valueOf(wcmMode.toUpperCase())) != null) {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)mode);
            }
            if ((servletResolver = this.slingHelper.getService(ServletResolver.class)) != null) {
                Servlet servlet = servletResolver.resolveServlet(this.request.getResource(), script);
                if (servlet != null) {
                    try {
                        PrintWriterResponseWrapper resWrapper = new PrintWriterResponseWrapper(out, this.response);
                        servlet.service((ServletRequest)this.request, (ServletResponse)resWrapper);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to include script {}", (Object)script, (Object)e);
                    }
                } else {
                    this.log.error("Failed to locate script {}", (Object)script);
                }
            } else {
                this.log.error("Sling ServletResolver service is unavailable, failed to include {}", (Object)script);
            }
            if (currentMode == null) {
                this.request.removeAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME);
            } else {
                this.request.setAttribute(WCMMode.REQUEST_ATTRIBUTE_NAME, (Object)currentMode);
            }
        }
    }

    public SightlyWCMMode getMode() {
        return this.mode;
    }

    private String[] splitCategories(Object obj) {
        if (obj != null && obj instanceof String) {
            return StringUtils.split((String)((String)obj), (String)",");
        }
        return new String[0];
    }

    private String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = this.request.getResource().getPath() + "/" + path;
        }
        return ResourceUtil.normalize(path);
    }
}

