/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AbstractSessionServlet;
import com.adobe.cq.social.commons.AsyncReverseReplicator;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false, componentAbstract=true)
public abstract class AbstractCreateCommentServlet
extends AbstractSessionServlet {
    public static final AgentFilter REV_AGENT_FILTER = new AgentFilter(){

        @Override
        public boolean isIncluded(Agent agent) {
            return agent.getConfiguration().isTriggeredOnDistribute();
        }
    };
    public static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    public static final String PROPERTY_ATTACHMENT_TYPE_BLACKLIST = "attachmentTypeBlacklist";
    public static final boolean DEFAULT_REVERSE_REPLICATE = true;
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"jcr:description", "email", "userIdentifier", "url"};
    private static final long serialVersionUID = 1L;
    private static final String TEMPLATE_MASK = "-template\\..*";
    protected static final String TEMPLATE_FORM_ID = ":templatename";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected Externalizer externalizer;
    protected boolean reverseReplicate;
    protected String[] fieldWhitelist;
    protected String[] attachmentTypeBlacklist;
    @Reference
    protected UserManagerFactory userManagerFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    protected AsyncReverseReplicator replicator;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.allowCORS(request, response);
    }

    protected boolean isBot(SlingHttpServletRequest request) {
        String botCheck = request.getParameter("id");
        return botCheck == null || !botCheck.equals("nobot");
    }

    protected ResourceResolver getResourceResolver(Session session) {
        return this.jcrResourceResolverFactory.getResourceResolver(session);
    }

    protected CommentSystem getCommentSystem(Resource r, Session session) {
        Resource res = this.getResourceResolver(session).resolve(r.getPath());
        if (null != res) {
            return res.adaptTo(CommentSystem.class);
        }
        return null;
    }

    protected Node getNode(String path, Session session) {
        Resource res = this.getResourceResolver(session).getResource(path);
        if (res != null) {
            return res.adaptTo(Node.class);
        }
        return null;
    }

    protected void redirect(SlingHttpServletRequest request, SlingHttpServletResponse response, String url) {
        try {
            String cp = request.getContextPath();
            String newURL = url;
            if (!("".equals(cp) || url.contains("://") || url.startsWith(cp))) {
                newURL = cp + url;
            }
            response.sendRedirect(newURL);
        }
        catch (IOException ioe) {
            this.log.error("failed to redirect to {}", (Object)url, (Object)ioe);
        }
    }

    protected void reverseReplicate(String path) {
        this.reverseReplicate(ReplicationActionType.ACTIVATE, path);
    }

    protected void reverseReplicate(ReplicationActionType actionType, String path) {
        if (this.reverseReplicate) {
            this.replicator.reverseReplicate(actionType, path);
        }
    }

    protected void reverseReplicate(ReplicationActionType actionType, List<String> paths) {
        if (this.reverseReplicate) {
            this.replicator.reverseReplicate(actionType, paths);
        }
    }

    private List<String> getPaths(Session session, String path) {
        ArrayList<String> paths = new ArrayList<String>();
        Node node = this.getResourceResolver(session).getResource(path).adaptTo(Node.class);
        paths.add(path);
        try {
            if (node.hasNode("attachments")) {
                Node attNode = node.getNode("attachments");
                NodeIterator iter = attNode.getNodes();
                while (iter.hasNext()) {
                    paths.add(iter.nextNode().getPath());
                }
            }
        }
        catch (PathNotFoundException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        catch (RepositoryException e) {
            this.log.error("Error with fetching attachment paths", (Object)path, (Object)e);
        }
        return paths;
    }

    protected void setCommentProperties(SlingHttpServletRequest request, Node node) throws RepositoryException {
        Calendar cal = Calendar.getInstance();
        node.setProperty("added", cal);
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        node.setProperty("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        node.setProperty("url", website);
        node.setProperty("ip", request.getRemoteAddr());
        node.setProperty("userAgent", request.getHeader("User-Agent"));
        node.setProperty("referer", request.getHeader("Referer"));
        this.setAuthorizableId(request, node);
        this.log.debug("additional properties set on " + node.getPath());
    }

    protected void setCommentProperties(SlingHttpServletRequest request, Comment comment) {
        ModifiableValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
        Calendar cal = Calendar.getInstance();
        properties.put("added", cal);
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        properties.put("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        properties.put("url", website);
        properties.put("ip", request.getRemoteAddr());
        properties.put("userAgent", request.getHeader("User-Agent"));
        properties.put("referer", request.getHeader("Referer"));
        this.setAuthorizableId(request, properties);
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key) || key.contains(":")) {
                this.log.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            if (!ArrayUtils.contains((Object[])RESERVED_PROPERTY_NAMES, (Object)key)) {
                RequestParameter[] values = (RequestParameter[])params.get(key);
                if (values.length > 0 && values[0].isFormField()) {
                    Object value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                    if (null == value) continue;
                    if (key.equals("userIdentifier") && ((String)value).length() == 0) {
                        this.log.debug("skipped custom form field \"userIdentifier\", empty value is not allowed.");
                        continue;
                    }
                    properties.put(key, value);
                    continue;
                }
                this.log.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
                continue;
            }
            this.log.debug("skipped custom form field [{}], matches reserved field name.", (Object)key);
        }
        this.log.debug("additional properties set on " + comment.getPath());
    }

    private void setAuthorizableId(SlingHttpServletRequest request, Node node) throws RepositoryException {
        String userIdentifier = request.getParameter("userIdentifier");
        String sessionUserId = request.getResourceResolver().getUserID();
        if (StringUtils.isNotBlank((String)sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, node.getSession());
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), node.getSession());
                if (userExists && hasPermissions) {
                    JcrUtil.setProperty(node, "authorizableId", userIdentifier);
                    if (!userIdentifier.equals(sessionUserId)) {
                        this.log.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                    }
                } else {
                    this.log.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(exceptionMessage);
                    }
                    throw new CommentException(exceptionMessage);
                }
                JcrUtil.setProperty(node, "authorizableId", userId);
            }
        }
    }

    private void setAuthorizableId(SlingHttpServletRequest request, ValueMap properties) {
        String userIdentifier = request.getParameter("userIdentifier");
        Session session = request.getResourceResolver().adaptTo(Session.class);
        String sessionUserId = request.getResourceResolver().getUserID();
        if (StringUtils.isNotBlank((String)sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, session);
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), session);
                if (userExists && hasPermissions) {
                    properties.put("authorizableId", userIdentifier);
                    if (!userIdentifier.equals(sessionUserId)) {
                        this.log.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                    }
                } else {
                    this.log.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(exceptionMessage);
                    }
                    throw new CommentException(exceptionMessage);
                }
                properties.put("authorizableId", userId);
            }
        }
    }

    protected void checkAuthorizableId(SlingHttpServletRequest request, Session adminSession) throws RepositoryException {
        String userIdentifier = request.getParameter("userIdentifier");
        String sessionUserId = request.getResourceResolver().getUserID();
        if (StringUtils.isNotBlank((String)sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, adminSession);
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), adminSession);
                if (userExists && hasPermissions && !userIdentifier.equals(sessionUserId)) {
                    this.log.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                }
            } else if (!authorMode) {
                if (!anonymous) {
                    if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                        StringBuilder exception = new StringBuilder("host ");
                        exception.append(request.getRemoteAddr());
                        exception.append("posted a comment with suspicious userIdentifier (");
                        exception.append(userIdentifier);
                        exception.append("), sessionUserId (");
                        exception.append(sessionUserId);
                        exception.append(")");
                        String exceptionMessage = exception.toString();
                        if (this.log.isWarnEnabled()) {
                            this.log.warn(exceptionMessage);
                        }
                        throw new CommentException(exceptionMessage);
                    }
                } else if (!this.validateAnonymousUserId(adminSession, sessionUserId, userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with invalid userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    this.log.warn(exceptionMessage);
                    throw new CommentException(exceptionMessage);
                }
            }
        }
    }

    private boolean validateAnonymousUserId(Session adminSession, String sessionUserId, String userId) {
        if ("anonymous".equals(sessionUserId)) {
            if (StringUtils.isNotBlank((String)userId)) {
                return !"anonymous".equals(userId) ? !this.userExists(userId, adminSession) : true;
            }
            return false;
        }
        return true;
    }

    private UserProperties getSessionUserProperties(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(UserProperties.class);
    }

    private Session getRequestSession(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(Session.class);
    }

    private boolean userExists(String userId, Session session) {
        try {
            UserManager userManager = this.userManagerFactory.createUserManager(session);
            return userManager.hasAuthorizable(userId);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean hasPermissions(String userIdentifier, Session requestSession, Session adminSession) {
        try {
            if (StringUtils.isNotBlank((String)userIdentifier)) {
                UserProperties userProperties = this.getResourceResolver(requestSession).adaptTo(UserProperties.class);
                if (requestSession != null) {
                    return requestSession.hasPermission(userProperties.getResource(".").getPath(), "read");
                }
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NoSuchAuthorizableException e) {
            return false;
        }
    }

    private boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected void activate(ComponentContext context) {
        this.reverseReplicate = OsgiUtil.toBoolean(context.getProperties().get(PROPERTY_REVERSE_REPLICATE), true);
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.attachmentTypeBlacklist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_ATTACHMENT_TYPE_BLACKLIST));
    }

    protected boolean writeUGCResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String location) throws ServletException, IOException {
        String extension = request.getRequestPathInfo().getExtension();
        boolean ugcResponseWritten = false;
        if (StringUtils.equalsIgnoreCase((String)extension, (String)"html")) {
            response.setHeader("Content-Type", "text/html");
            response.setCharacterEncoding("utf-8");
            TemplateHandlingRequest includeRequest = new TemplateHandlingRequest(request);
            String templateRequested = request.getParameter(TEMPLATE_FORM_ID);
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (null != templateRequested) {
                String locationURL;
                response.setStatus(201);
                String string = locationURL = null != location ? location : resource.getPath();
                if (!this.isCORS(request).booleanValue()) {
                    response.setHeader("Location", locationURL);
                } else {
                    response.setHeader("Location", this.externalizer.absoluteLink(request, request.getScheme(), locationURL));
                }
                options.setReplaceSelectors(templateRequested);
                includeRequest.getRequestDispatcher(resource, options).include((ServletRequest)includeRequest, (ServletResponse)response);
                ugcResponseWritten = true;
            }
        }
        return ugcResponseWritten;
    }

    protected boolean writeUGCResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws ServletException, IOException {
        return this.writeUGCResponse(request, response, resource, null);
    }

    protected String getResourceSuperType(SlingHttpServletRequest request, String resourceType) {
        String type = ResourceUtil.getResourceSuperType(request.getResourceResolver(), resourceType);
        return type;
    }

    private List<String> collectTemplates(Resource resource) {
        ArrayList<String> templates = new ArrayList<String>();
        if (resource == null) {
            return templates;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        if (resource.getResourceSuperType() != null) {
            templates.addAll(this.collectTemplates(resourceResolver.getResource(resource.getResourceSuperType())));
        }
        Iterator<Resource> childIterator = resource.listChildren();
        while (childIterator.hasNext()) {
            String templateName = childIterator.next().getName();
            if (!templateName.matches(TEMPLATE_MASK)) continue;
            templates.add(templateName);
        }
        return templates;
    }

    protected Boolean isCORS(SlingHttpServletRequest request) {
        if (null == this.externalizer) {
            return false;
        }
        String localOrigin = this.externalizer.absoluteLink(request, request.getScheme(), "");
        if (!localOrigin.equals(request.getHeader("Origin"))) {
            return true;
        }
        return false;
    }

    protected void allowCORS(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (null == this.externalizer) {
            return;
        }
        String localOrigin = this.externalizer.absoluteLink(request, request.getScheme(), "");
        if (!localOrigin.equals(request.getHeader("Origin"))) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.setHeader("Access-Control-Allow-Headers", "CONTENT-TYPE, LOCATION, *");
            response.setHeader("Access-Control-Expose-Headers", "Content-Type, Location");
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        this.replicator = asyncReverseReplicator;
    }

    protected void unbindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        if (this.replicator == asyncReverseReplicator) {
            this.replicator = null;
        }
    }

    private class TemplateHandlingRequest
    extends SlingHttpServletRequestWrapper {
        public TemplateHandlingRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

