/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AttachmentDataSource;
import com.adobe.cq.social.commons.AttachmentTypeBlacklistService;
import com.adobe.cq.social.commons.CollabException;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.FileDataSource;
import com.adobe.cq.social.commons.FileUploadSizeLimit;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.ugcbase.SocialResourceUtils;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CollabUtil {
    public static String PN_REMOTE_UGC_LOCATION = "remoteUGC";
    private static final Logger log = LoggerFactory.getLogger(CollabUtil.class);
    public static final String BUCKET_TYPE = "sling:Folder";
    @Deprecated
    public static final String REQ_ATTR_SOCIAL_PROFILE_PAGE = "cq.social.profile.page";
    public static final String GROUP_MEMBERGROUP = "membergroup";
    public static String DEFAULT_AVATAR = "/etc/designs/default/images/social/avatar.png";
    private static SecureRandom randomGenerator = new SecureRandom();
    private static char[] RANDOM_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    private static boolean isUGCPath(Resource resource) {
        return StringUtils.contains((String)resource.getPath(), (String)"/content/usergenerated");
    }

    public static boolean isCommunityGroupResource(Resource resource) {
        return null != CollabUtil.getCommunityGroupUGCPath(resource);
    }

    public static String getCommunityGroupUGCPath(Resource resource) {
        Resource contentResource = resource;
        if (CollabUtil.isUGCPath(resource)) {
            String contentPath = StringUtils.substringAfter((String)resource.getPath(), (String)"/content/usergenerated");
            int endPos = StringUtils.lastIndexOf((String)contentPath, (String)"jcr:content");
            if (endPos == -1) {
                return null;
            }
            contentPath = StringUtils.left((String)contentPath, (int)(endPos += "jcr:content".length()));
            contentResource = resource.getResourceResolver().getResource(contentPath);
            if (contentResource == null) {
                return null;
            }
        }
        PageManager pm = contentResource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(contentResource);
        ValueMap properties = null;
        String groupProp = null;
        String communityPath = null;
        if (page != null) {
            properties = page.getProperties();
            groupProp = properties.get(GROUP_MEMBERGROUP, null);
            while (groupProp == null && (page = page.getParent()) != null) {
                properties = page.getProperties();
                groupProp = properties.get(GROUP_MEMBERGROUP, null);
            }
            if (groupProp != null) {
                communityPath = "/content/usergenerated" + page.getPath();
            }
        }
        return communityPath;
    }

    public static boolean hasModeratePermissions(Resource resource) {
        if (!CollabUtil.isUGCResource(resource)) {
            return false;
        }
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        try {
            String ACTION_ALL = "read,add_node,remove,set_property";
            return session.hasPermission(resource.getPath(), "read,add_node,remove,set_property");
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    public static boolean isResourceOwner(Resource resource) {
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        ValueMap map = resource.adaptTo(ValueMap.class);
        String resourceAuthorID = (String)((Object)map.get("userIdentifier", String.class));
        String authorID = (String)((Object)map.get("jcr:createdBy", String.class));
        if (StringUtils.isEmpty((String)resourceAuthorID)) {
            resourceAuthorID = (String)((Object)map.get("jcr:lastModifiedBy", String.class));
        }
        return StringUtils.equals((String)session.getUserID(), (String)resourceAuthorID) || StringUtils.equals((String)session.getUserID(), (String)authorID);
    }

    public static String resourceToUGCPath(Resource resource) {
        if (resource == null) {
            return null;
        }
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        if (socialUtils != null) {
            return socialUtils.resourceToUGCPath(resource);
        }
        log.debug("In function: resourceToUGCPath");
        String resourcePath = resource.getPath();
        log.debug("resourcePath: {}", (Object)resourcePath);
        if (resourcePath.startsWith("/content/usergenerated")) {
            return resourcePath;
        }
        StringBuilder path = new StringBuilder();
        MachineTranslationUtil mtu = resource.getResourceResolver().adaptTo(MachineTranslationUtil.class);
        if (mtu != null) {
            MachineTranslationCloudConfig cloudConfig = mtu.getAppliedMachineTranslationCloudConfigs(resource);
            if (cloudConfig != null) {
                String ugcRoot = cloudConfig.getUgcPath();
                log.debug("Applied ugcRoot: {}", (Object)ugcRoot);
                if (!ugcRoot.startsWith("/content/usergenerated")) {
                    path.append("/content/usergenerated");
                }
                if (ugcRoot.endsWith("/")) {
                    path.append(StringUtils.substringBeforeLast((String)ugcRoot, (String)"/"));
                } else {
                    path.append(ugcRoot);
                }
                path.append(CollabUtil.stripLanguageRoot(resource));
            } else {
                path.append("/content/usergenerated");
                if (!resource.getPath().contains("jcr:content")) {
                    path.append(resource.getPath());
                } else {
                    path.append(CollabUtil.getPagePath(resource));
                    path.append("/").append("jcr:content");
                    path.append("/").append(CollabUtil.getIdFromResource(resource));
                }
            }
        }
        log.debug("Returning ugc path: {}", (Object)path.toString());
        return path.toString();
    }

    private static String stripLanguageRoot(Resource resource) {
        StringBuilder pathWithoutExtensions;
        log.debug("In Function: stripLanguageRoot");
        String ISO_PROP_NAME = "jcr:content/jcr:language";
        String pathMinusLanguageRoot = "";
        log.debug("resource.getPath(): {}", (Object)resource.getPath());
        if (!resource.getPath().contains("jcr:content")) {
            pathWithoutExtensions = new StringBuilder(resource.getPath());
        } else {
            pathWithoutExtensions = new StringBuilder();
            pathWithoutExtensions.append(CollabUtil.getPagePath(resource));
            pathWithoutExtensions.append("/").append("jcr:content");
            pathWithoutExtensions.append("/").append(CollabUtil.getIdFromResource(resource));
        }
        Node pageNode = resource.adaptTo(Node.class);
        try {
            while (pageNode != null && !pageNode.hasProperty("jcr:content/jcr:language") && LanguageUtil.getLocale(pageNode.getName()) == null) {
                pageNode = pageNode.getDepth() <= 1 ? null : pageNode.getParent();
            }
            if (pageNode != null) {
                log.debug("pageNode path: {}", (Object)pageNode.getPath());
                pathMinusLanguageRoot = StringUtils.substringAfter((String)pathWithoutExtensions.toString(), (String)pageNode.getPath());
            }
        }
        catch (AccessDeniedException e) {
            try {
                log.info("Could not access parent of {} to look for the page language", (Object)pageNode.getPath());
            }
            catch (RepositoryException ignore) {}
        }
        catch (RepositoryException e) {
            log.error("Error while evaluating content language.", (Throwable)e);
        }
        log.debug("pathMinusLanguageRoot: {}", (Object)pathMinusLanguageRoot);
        return pathMinusLanguageRoot;
    }

    public static String UGCToResourcePath(Resource resource) {
        return CollabUtil.UGCToResourcePath(resource.getPath(), resource.getResourceResolver());
    }

    public static String UGCToResourcePath(String ugcPath, ResourceResolver resolver) {
        String pagePath = StringUtils.substringAfter((String)ugcPath, (String)"/content/usergenerated");
        return resolver.map(pagePath);
    }

    public static String getPagePath(Resource resource) {
        return CollabUtil.getPagePath(resource.getPath());
    }

    public static String getPagePath(String path) {
        return StringUtils.substringBefore((String)path, (String)"/jcr:content");
    }

    public static String getIdFromResource(Resource resource) {
        return StringUtils.substringBefore((String)ResourceUtil.getName(resource), (String)".");
    }

    public static boolean canAddNode(Session session, String path) {
        try {
            StringBuilder childPath = new StringBuilder(path).append("/foo_").append(new Date().getTime());
            return session != null && session.hasPermission(childPath.toString(), "add_node");
        }
        catch (RepositoryException e) {
            log.error("canAddNode: error while checking add node permission on[{}]", (Object)path, (Object)e);
            return false;
        }
    }

    @Deprecated
    public static String getAvatar(Profile profile) {
        return CollabUtil.getAvatar(profile, null, null);
    }

    public static String getAvatar(UserProperties userProperties) {
        return CollabUtil.getAvatar(userProperties, null, null);
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar) {
        return CollabUtil.getAvatar(userProperties, email, absoluteDefaultAvatar, AVATAR_SIZE.THIRTY_TWO);
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        String avatar = DEFAULT_AVATAR;
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail." + size.toString() + ".png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("getAvatar: error getting avatar: ", (Throwable)e);
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    @Deprecated
    public static String getAvatar(Profile profile, String email, String absoluteDefaultAvatar) {
        String avatar = DEFAULT_AVATAR;
        if (profile != null) {
            String avatarPath = profile.getAvatarURL(".prof.thumbnail.32.png", null);
            if (avatarPath != null) {
                avatar = avatarPath;
            } else {
                String gravatar;
                String primaryMail = profile.getPrimaryMail();
                if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                    avatar = gravatar;
                }
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    @Deprecated
    public static String getAvatar(Profile profile, String email, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        String avatar = DEFAULT_AVATAR;
        if (profile != null) {
            String avatarPath = profile.getAvatarURL(".prof.thumbnail." + size.size + ".png", null);
            if (avatarPath != null) {
                avatar = avatarPath;
            } else {
                String gravatar;
                String primaryMail = profile.getPrimaryMail();
                if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                    avatar = gravatar;
                }
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    public static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank((String)email) || StringUtils.isBlank((String)absoluteDefaultAvatar)) {
            return null;
        }
        try {
            email = Text.md5(email, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://www.gravatar.com/avatar/");
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static String generateRandomString(int length) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            str.append(RANDOM_CHARS[randomGenerator.nextInt(RANDOM_CHARS.length)]);
        }
        return str.toString();
    }

    public static String prepareUserGeneratedContent(ResourceResolver resolver, String path) throws CollabException {
        log.debug("In Function: prepareUserGeneratedContent with path: {}", (Object)path);
        String pathToUgc = path;
        if (!path.startsWith("/content/usergenerated")) {
            pathToUgc = CollabUtil.resourceToUGCPath(resolver.getResource(path));
        }
        String ugcPagePath = "";
        StringTokenizer pathElems = new StringTokenizer(pathToUgc, "/");
        while (pathElems.hasMoreTokens()) {
            ugcPagePath = ugcPagePath + "/" + pathElems.nextToken();
            log.debug("ugcPagePath: {}", (Object)ugcPagePath);
            if (resolver.getResource(ugcPagePath) != null) continue;
            if (ugcPagePath.equals("/content/usergenerated/content")) {
                try {
                    CollabUtil.createNode(resolver, ugcPagePath, BUCKET_TYPE);
                    CollabUtil.save(resolver);
                    continue;
                }
                catch (CollabException ce) {
                    throw new CommentException("failed to prepare user generated content", ce);
                }
            }
            try {
                CollabUtil.createPage(resolver, ugcPagePath, null, null, null, null);
            }
            catch (CollabException ce) {
                if (!CollabUtil.causeByStaleSessionException(ce)) {
                    throw new CommentException("failed to prepare user generated content", ce);
                }
                try {
                    resolver.adaptTo(Session.class).refresh(false);
                }
                catch (RepositoryException e) {
                    throw new CommentException("failed to prepare user generated content", e);
                }
            }
        }
        return ugcPagePath;
    }

    public static void save(ResourceResolver resolver) throws CollabException, IllegalArgumentException {
        Session session = resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        try {
            session.save();
        }
        catch (RepositoryException re) {
            throw new CollabException("failed to save changes", re);
        }
    }

    public static Page createPage(ResourceResolver resolver, String path, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        String parentPath = Text.getRelativeParent(path, 1);
        String name = Text.getName(path);
        return CollabUtil.createPage(resolver, parentPath, name, template, resourceTypeProp, resourceType, title);
    }

    public static Page createPage(ResourceResolver resolver, String parentPath, String name, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        Throwable e;
        try {
            if (resolver.getResource(parentPath) == null) {
                CollabUtil.createNode(resolver, parentPath, "nt:unstructured");
                CollabUtil.save(resolver);
            }
            if (!JcrUtil.isValidName(name)) {
                name = JcrUtil.createValidName(name, JcrUtil.HYPHEN_LABEL_CHAR_MAPPING);
            }
            Page page = resolver.adaptTo(PageManager.class).create(parentPath, name, template, title);
            if (StringUtils.isNotEmpty((String)resourceTypeProp)) {
                page.getContentResource().adaptTo(Node.class).setProperty(resourceTypeProp, resourceType);
            }
            return page;
        }
        catch (RepositoryException re) {
            e = re;
        }
        catch (WCMException wcme) {
            e = wcme;
        }
        catch (CollabException ce) {
            e = ce;
        }
        throw new CollabException("failed to create page", e);
    }

    public static Node createNode(ResourceResolver resolver, String path, String nodeType) throws CollabException {
        try {
            return CollabUtil.createNode(resolver.adaptTo(Session.class), path, nodeType);
        }
        catch (Exception e) {
            throw new CollabException("failed to create node", e);
        }
    }

    public static Node createNode(Session session, String path, String nodeType) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            Node root = session.getRootNode();
            StringTokenizer names = new StringTokenizer(Text.getRelativeParent(path, 1), "/");
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                if (!root.hasNode(name)) {
                    root.addNode(name);
                }
                root = root.getNode(name);
            }
            String newNodeName = Text.getName(path);
            if (!root.hasNode(newNodeName)) {
                return root.addNode(newNodeName, nodeType);
            }
            return root.getNode(newNodeName);
        }
        catch (RepositoryException e) {
            throw new CommentException("Failed to create node", e);
        }
    }

    public static void setNodeProperty(Node node, String name, Object value) throws RepositoryException {
        if (value instanceof Value) {
            node.setProperty(name, (Value)value);
        } else {
            JcrUtil.setProperty(node, name, value);
        }
    }

    @Deprecated
    public static Profile getProfile(ResourceResolver resolver, ProfileManager pm, String userId) {
        Profile profile = null;
        if (null != pm && null != userId) {
            try {
                Session session = resolver.adaptTo(Session.class);
                profile = pm.getProfile(userId, session);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return profile;
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return userProperties;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        return SocialResourceUtils.causeByInvalidItemStateException(e);
    }

    private static boolean causeByStaleSessionException(Exception e) {
        Throwable cause = e;
        do {
            if (cause instanceof InvalidItemStateException) {
                return true;
            }
            if (!(cause instanceof ItemExistsException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    @Deprecated
    public static boolean mayEdit(ResourceResolver resolver, String authorizableID, Comment comment) {
        return CollabUtil.canAddNode(resolver.adaptTo(Session.class), "/content/usergenerated") && comment.getAuthor().getId().equals(authorizableID);
    }

    public static String formatFileSize(long size) {
        String[] units = new String[]{" bytes", " KB", " MB", " GB", " TB"};
        int u = 0;
        long mod = 0L;
        while (size > 1000L) {
            mod = size % 1000L;
            size /= 1000L;
            ++u;
        }
        long frac = mod / 100L;
        if (frac == 0L) {
            return size + units[u];
        }
        return size + "." + frac + units[u];
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, long attachmentSizeLimit, List<String> whitelist, String[] blacklist) {
        return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, new FileUploadSizeLimit(attachmentSizeLimit, attachmentSizeLimit), whitelist, blacklist);
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, FileUploadSizeLimit fileUploadSizeLimit, List<String> whitelist, String[] blacklist) {
        List<DataSource> attachments = Collections.emptyList();
        HashSet<String> whitelistSet = null;
        if (whitelist != null) {
            whitelistSet = new HashSet<String>(whitelist);
        }
        if (fileRequestParameters != null && fileRequestParameters.length > 0 && !fileRequestParameters[0].isFormField()) {
            attachments = new ArrayList<DataSource>();
            for (RequestParameter fileRequestParameter : fileRequestParameters) {
                if (fileUploadSizeLimit.fits(fileRequestParameter)) {
                    FileDataSource filteredAttachment = CollabUtil.getAttachmentFromDataSource(new AttachmentDataSource(fileRequestParameter), fileUploadSizeLimit, whitelistSet, blacklist);
                    if (filteredAttachment == null) continue;
                    attachments.add(filteredAttachment);
                    continue;
                }
                log.info("File bigger than specified size, so ignoring the attachment");
            }
        }
        return attachments;
    }

    public static Iterable<DataSource> getAttachmentsFromDataSources(Iterable<FileDataSource> attachmentList, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklist) {
        ArrayList<DataSource> attachments = new ArrayList<DataSource>();
        for (FileDataSource attachmentDataSource : attachmentList) {
            FileDataSource filteredAttachment = CollabUtil.getAttachmentFromDataSource(attachmentDataSource, fileUploadSizeLimit, whitelist, blacklist);
            if (filteredAttachment == null) continue;
            attachments.add(filteredAttachment);
        }
        return attachments;
    }

    public static FileDataSource getAttachmentFromDataSource(FileDataSource attachmentDataSource, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklistIn) {
        AttachmentTypeBlacklistService attachmentTypeBlacklistService = Activator.getService(AttachmentTypeBlacklistService.class);
        Object[] blacklist = blacklistIn;
        if (attachmentTypeBlacklistService != null) {
            blacklist = attachmentTypeBlacklistService.getBlacklist(blacklistIn);
        }
        if (fileUploadSizeLimit.fits(attachmentDataSource)) {
            String contentFileType = attachmentDataSource.getTypeFromFileName();
            String contentType = attachmentDataSource.getType();
            if (StringUtils.isNotBlank((String)contentFileType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentFileType)) {
                if (whitelist != null && !whitelist.isEmpty()) {
                    if (StringUtils.isNotBlank((String)contentType) && whitelist.contains(contentType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank((String)contentType)) {
                        log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the" + " servlet's attachment black list");
                    } else {
                        log.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                } else {
                    if (StringUtils.isNotBlank((String)contentType) && !ArrayUtils.contains((Object[])blacklist, (Object)contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank((String)contentType)) {
                        log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the" + " servlet's attachment black list");
                    } else {
                        log.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                }
            } else if (StringUtils.isNotBlank((String)contentFileType)) {
                log.info("File of type " + contentFileType + "with name " + attachmentDataSource.getName() + " is blacklisted for security reasons. To upload edit the" + " servlet's attachment black list");
            } else {
                log.info("File doesn't have a valid extension. Not attaching it as it is suspicious");
            }
        } else {
            log.info("File bigger than specified size, so ignoring the attachment");
        }
        return null;
    }

    public static String getValueString(Object value) throws RepositoryException {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            throw new RepositoryException("Specified value is an array.");
        }
        if (value instanceof Value) {
            return ((Value)value).getString();
        }
        return value.toString();
    }

    protected static boolean isUGCResource(Resource resource) {
        return StringUtils.startsWith((String)resource.getPath(), (String)"/content/usergenerated");
    }

    public static enum AVATAR_SIZE {
        THIRTY_TWO(32),
        FOURTY_EIGHT(48),
        THIRTY_FOUR(34);

        private final int size;

        private AVATAR_SIZE(int s) {
            this.size = s;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }
}

