/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.DefaultResourceID;
import com.adobe.cq.social.commons.client.api.JsonException;
import com.adobe.cq.social.commons.client.api.ResourceID;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, isGetterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class BaseSocialComponent
implements SocialComponent {
    private static ObjectMapper objectMapper = new ObjectMapper();
    protected final Resource resource;
    protected final ResourceID id;
    protected final Properties properties;
    protected ClientUtilities clientUtils;
    protected final List<String> ignoredProperties = new ArrayList<String>(Arrays.asList("cq:.*", "ip", "email", "userAgent", "sling:.*"));
    private final List<String> whiteList = Arrays.asList("cq:tags");

    public BaseSocialComponent(Resource resource, ClientUtilities clientUtils) {
        this.resource = resource;
        this.id = new DefaultResourceID(resource);
        this.properties = this.getPropertiesFromValueMap();
        this.clientUtils = clientUtils;
    }

    @Override
    public ResourceID getId() {
        return this.id;
    }

    @Override
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getUrl() {
        return this.externalizeURL(this.resource.getPath());
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    private Properties getPropertiesFromValueMap() {
        Properties props = new Properties();
        ValueMap propMap = this.resource.adaptTo(ValueMap.class);
        if (propMap != null) {
            for (String key : propMap.keySet()) {
                if (this.isKeyIgnored(key)) continue;
                props.setProperty(key, propMap.get(key, ""));
            }
        }
        return props;
    }

    protected boolean isKeyIgnored(String key) {
        for (String ignoredKey : this.getIgnoredProperties()) {
            if (!key.matches(ignoredKey) || this.whiteList.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    @Override
    @JsonIgnore
    public String toJSONString(boolean tidy) throws JsonException {
        try {
            if (tidy) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Error converting " + this.id + " to JSON", e);
        }
    }

    @Override
    @JsonIgnore
    public Resource getResource() {
        return this.resource;
    }

    protected String externalizeURL(String path) {
        if (this.clientUtils == null) {
            return path;
        }
        return this.clientUtils.externalLink(path);
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getAsMap() {
        return (Map)objectMapper.convertValue((Object)this, Map.class);
    }

    static {
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
    }
}

