/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.client.api;

import com.adobe.cq.social.commons.client.api.BaseQueryRequestInfo;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.CollectionSortedOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface QueryRequestInfo {
    public static final QueryRequestInfoFactory DEFAULT_QUERY_INFO_FACTORY = new QueryRequestInfoFactory(){

        @Override
        public QueryRequestInfo create() {
            return new BaseQueryRequestInfo(false, Collections.<String, String[]>emptyMap(), CollectionPagination.DEFAULT_PAGINATION);
        }

        @Override
        public QueryRequestInfo create(QueryRequestInfo copyFrom) {
            BaseQueryRequestInfo newQueryInfo = new BaseQueryRequestInfo(copyFrom.isQuery(), new HashMap<String, String[]>(copyFrom.getPredicates()), new CollectionPagination(copyFrom.getPagination()));
            if (copyFrom.getSortBy() != null) {
                newQueryInfo.setSortBy(new ArrayList<String>(copyFrom.getSortBy()));
            }
            newQueryInfo.setSortOrder(copyFrom.getSortOrder());
            return newQueryInfo;
        }
    };

    public boolean isQuery();

    public Map<String, String[]> getPredicates();

    public CollectionPagination getPagination();

    public void setPagination(CollectionPagination var1);

    public void setSortBy(List<String> var1);

    public List<String> getSortBy();

    public void setSortOrder(CollectionSortedOrder var1);

    public CollectionSortedOrder getSortOrder();

    public static interface QueryRequestInfoFactory {
        public QueryRequestInfo create();

        public QueryRequestInfo create(QueryRequestInfo var1);
    }
}

