/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.sling.api.resource.Resource;

public class AbstractCommentCollectionConfiguration
implements CommentCollectionConfiguration {
    private final boolean allowsVoting;
    private final boolean isRTEEnabled;
    private final boolean allowsAttachment;
    private boolean allowsCustomFlagReason = true;
    private int pageSize = 10;

    public AbstractCommentCollectionConfiguration(Resource resource, CommentSystem cs) {
        this.allowsCustomFlagReason = cs.allowCustomFlagReason();
        Resource component = cs.getResource();
        this.allowsVoting = CommentUtil.isAllowVoting(component);
        this.isRTEEnabled = cs.isRteEnabled();
        this.allowsAttachment = cs.allowsAttachment();
        this.pageSize = cs.getProperty("maxPerPage", 10);
    }

    @Override
    @JsonProperty(value="isVotingAllowed")
    public boolean isVotingAllowed() {
        return this.allowsVoting;
    }

    @Override
    @JsonProperty(value="isAttachmentAllowed")
    public boolean isAttachmentAllowed() {
        return this.allowsAttachment;
    }

    @Override
    @JsonProperty(value="isRTEEnabled")
    public boolean isRTEEnabled() {
        return this.isRTEEnabled;
    }

    @Override
    @JsonProperty(value="isCustomFlagReasonAllowed")
    public boolean isCustomFlagReasonAllowed() {
        return this.allowsCustomFlagReason;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }
}

