/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.endpoints;

import com.adobe.cq.social.commons.AsyncReverseReplicator;
import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.Comment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.client.endpoints.AbstractOperationService;
import com.adobe.cq.social.commons.client.endpoints.Operation;
import com.adobe.cq.social.commons.client.endpoints.OperationException;
import com.adobe.cq.social.commons.client.endpoints.OperationExtension;
import com.adobe.cq.social.commons.events.SocialEvent;
import com.adobe.cq.social.ugcbase.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.Externalizer;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@Property(name="reverseReplicate", boolValue={true}), @Property(name="fieldWhitelist", value={"cq:tags", "tags"}, cardinality=100), @Property(name="attachmentTypeBlacklist", cardinality=0x7FFFFFFF, value={"DEFAULT"})})
public abstract class AbstractCommentOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, Comment> {
    private static final String CQ_TAGS_PROPERTY = "cq:tags";
    public static final String CHARSET_PROPERTY = "_charset_";
    public static final String TAGS_PROPERTY = "tags";
    public static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    public static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";
    public static final String[] RESERVED_PROPERTY_NAMES = new String[]{"email", "userIdentifier", "url"};
    public static final String PROPERTY_ATTACHMENT_TYPE_BLACKLIST = "attachmentTypeBlacklist";
    public static final boolean DEFAULT_REVERSE_REPLICATE = true;
    public static final String PROP_MESSAGE = "message";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentOperationService.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected Externalizer externalizer;
    @Reference
    protected UserManagerFactory userManagerFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    protected AsyncReverseReplicator replicator;
    @Reference
    protected EventAdmin eventAdmin;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    protected boolean reverseReplicate;
    protected String[] fieldWhitelist;
    protected String[] attachmentTypeBlacklist;
    private ComponentContext context;

    protected void getDefaultProperties(SlingHttpServletRequest request, Map<String, Object> props, Session session) throws RepositoryException, OperationException {
        String authId;
        Calendar cal = Calendar.getInstance();
        props.put("added", cal);
        String email = request.getParameter("email");
        if (email == null) {
            email = "";
        }
        props.put("email", email);
        String website = request.getParameter("url");
        if (website == null) {
            website = "";
        } else if (!"".equals(website) && !website.matches("^.*\\:\\/\\/.*$")) {
            website = "http://" + website;
        }
        props.put("url", website);
        props.put("ip", this.getClientIpAddr(request));
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent)) {
            props.put("userAgent", request.getHeader("User-Agent"));
        }
        if (StringUtils.isNotBlank((CharSequence)(authId = this.getAuthorizableId(request, session)))) {
            props.put("authorizableId", authId);
        }
        this.addProp(props, "Referer", request, session);
        String value = request.getParameter(PROP_MESSAGE);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            props.put(PROP_MESSAGE, value);
        }
    }

    private String getClientIpAddr(SlingHttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private void addProp(Map<String, Object> props, String name, SlingHttpServletRequest request, Session session) throws RepositoryException {
        String value = request.getParameter(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            props.put(name, value);
        }
    }

    protected void getCustomProperties(SlingHttpServletRequest request, Map<String, Object> map, Session session) throws RepositoryException {
        RequestParameterMap params = request.getRequestParameterMap();
        for (String key : params.keySet()) {
            if (map.containsKey(key) || StringUtils.equals((CharSequence)key, (CharSequence)CHARSET_PROPERTY)) continue;
            if (!ArrayUtils.contains((Object[])this.fieldWhitelist, (Object)key) || key.contains(":")) {
                LOG.debug("skipped custom form field [{}], not in white list.", (Object)key);
                continue;
            }
            if (!ArrayUtils.contains((Object[])RESERVED_PROPERTY_NAMES, (Object)key)) {
                RequestParameter[] values = (RequestParameter[])params.get(key);
                if (values.length > 0 && values[0].isFormField()) {
                    Object value = values.length == 1 ? values[0].getString() : request.getParameterValues(key);
                    if (null == value) continue;
                    if (key.equals("userIdentifier") && ((String)value).length() == 0) {
                        LOG.debug("skipped custom form field \"userIdentifier\", empty value is not allowed.");
                        continue;
                    }
                    map.put(key, value);
                    continue;
                }
                LOG.debug("skipped custom form field [{}], empty or binary not allowed.", (Object)key);
                continue;
            }
            LOG.debug("skipped custom form field [{}], matches reserved field name.", (Object)key);
        }
    }

    protected List<DataSource> getAttachmentsFromRequest(SlingHttpServletRequest request, CommentSystem cs) {
        if (BooleanUtils.toBoolean((Boolean)cs.allowsAttachment())) {
            RequestParameter[] fileRequestParameters = request.getRequestParameters("file");
            return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, cs.getAttachmentSizeLimit(), cs.getAllowedFileTypes(), this.attachmentTypeBlacklist);
        }
        return Collections.emptyList();
    }

    protected boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected boolean isBot(SlingHttpServletRequest request) {
        String botCheck = request.getParameter("id");
        return botCheck == null || !botCheck.equals("nobot");
    }

    protected ResourceResolver getResourceResolver(Session session) throws LoginException {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", session);
        return this.resourceResolverFactory.getResourceResolver(authInfo);
    }

    protected CommentSystem getCommentSystem(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", (Throwable)e);
            return null;
        }
        if (null != res) {
            return res.adaptTo(CommentSystem.class);
        }
        return null;
    }

    protected Comment getComment(Resource r, Session session) {
        Resource res;
        try {
            res = this.getResourceResolver(session).resolve(r.getPath());
        }
        catch (LoginException e) {
            LOG.error("Unable to fetch resource resolver for session", (Throwable)e);
            return null;
        }
        if (null != res) {
            return res.adaptTo(Comment.class);
        }
        return null;
    }

    protected String getAuthorizableId(SlingHttpServletRequest request, Session session) throws OperationException {
        String userIdentifier = request.getParameter("userIdentifier");
        if (StringUtils.isBlank((CharSequence)userIdentifier)) {
            userIdentifier = this.getUserIdFromRequest(request, "Anonymous");
        }
        String sessionUserId = this.getUserIdFromRequest(request, null);
        String id = "";
        if (StringUtils.isNotBlank((CharSequence)sessionUserId)) {
            boolean anonymous = "anonymous".equals(sessionUserId);
            boolean authorMode = this.isAuthorMode();
            if (!anonymous && authorMode) {
                boolean userExists = this.userExists(userIdentifier, session);
                boolean hasPermissions = this.hasPermissions(userIdentifier, this.getRequestSession(request), session);
                if (userExists && hasPermissions) {
                    id = userIdentifier;
                    if (!userIdentifier.equals(sessionUserId)) {
                        LOG.warn("host {} posted a comment with different userIdentifier ({}) than sessionUserId ({})", (Object[])new String[]{request.getRemoteAddr(), userIdentifier, sessionUserId});
                    }
                } else {
                    LOG.warn("host {} posted a comment with an unknown userIdentifier ({})", (Object)request.getRemoteAddr(), (Object)userIdentifier);
                }
            } else if (!anonymous && !authorMode) {
                String userId = sessionUserId;
                if (userIdentifier != null && !sessionUserId.equals(userIdentifier)) {
                    StringBuilder exception = new StringBuilder("host ");
                    exception.append(request.getRemoteAddr());
                    exception.append("posted a comment with suspect userIdentifier (");
                    exception.append(userIdentifier);
                    exception.append("), sessionUserId (");
                    exception.append(sessionUserId);
                    exception.append(")");
                    String exceptionMessage = exception.toString();
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(exceptionMessage);
                    }
                    throw new OperationException(exceptionMessage, 404);
                }
                id = userId;
            } else {
                id = "anonymous";
            }
        }
        return id;
    }

    protected String getUserIdFromRequest(SlingHttpServletRequest request, String defaultValue) {
        String userIdentifier;
        UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
        String string = userIdentifier = up == null ? null : up.getAuthorizableID();
        if (userIdentifier == null) {
            userIdentifier = defaultValue;
        }
        return userIdentifier;
    }

    protected UserProperties getSessionUserProperties(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(UserProperties.class);
    }

    protected Session getRequestSession(SlingHttpServletRequest request) {
        return request.getResourceResolver().adaptTo(Session.class);
    }

    protected boolean userExists(String userId, Session session) {
        try {
            UserManager userManager = this.userManagerFactory.createUserManager(session);
            return userManager.hasAuthorizable(userId);
        }
        catch (AccessDeniedException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean hasPermissions(String userIdentifier, Session requestSession, Session adminSession) {
        try {
            if (StringUtils.isNotBlank((CharSequence)userIdentifier)) {
                UserProperties userProperties = this.getResourceResolver(requestSession).adaptTo(UserProperties.class);
                if (requestSession != null) {
                    return requestSession.hasPermission(userProperties.getResource(".").getPath(), "read");
                }
            }
            return false;
        }
        catch (LoginException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (NoSuchAuthorizableException e) {
            return false;
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
        this.reverseReplicate = OsgiUtil.toBoolean(context.getProperties().get(PROPERTY_REVERSE_REPLICATE), true);
        this.fieldWhitelist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_FIELD_WHITELIST));
        this.attachmentTypeBlacklist = OsgiUtil.toStringArray(context.getProperties().get(PROPERTY_ATTACHMENT_TYPE_BLACKLIST));
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    protected Resource getResource(String path, Session session) {
        try {
            return this.getResourceResolver(session).getResource(path);
        }
        catch (LoginException e) {
            LOG.error("Error getching the resource resolver from session", (Throwable)e);
            return null;
        }
    }

    protected void postEvent(SocialEvent event) {
        EventAdmin localEventAdminRef = this.eventAdmin;
        if (null != localEventAdminRef) {
            localEventAdminRef.postEvent((Event)event);
        }
    }

    protected void reverseReplicate(String path) {
        if (this.reverseReplicate) {
            this.reverseReplicate(ReplicationActionType.ACTIVATE, path);
        }
    }

    protected void reverseReplicate(ReplicationActionType actionType, String path) {
        this.replicator.reverseReplicate(ReplicationActionType.ACTIVATE, path);
    }

    protected void reverseReplicate(ReplicationActionType actionType, List<String> paths) {
        if (this.reverseReplicate) {
            this.replicator.reverseReplicate(actionType, paths);
        }
    }

    protected Resource create(Resource root, CommentSystem cs, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        String postFix;
        Object v;
        boolean rootPathExists;
        String message;
        U createOperation = this.getCreateOperation();
        this.performBeforeActions(createOperation, session, root, props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + root.getPath() + "' ", 404);
        }
        try {
            message = this.getStringProperty(PROP_MESSAGE, props);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get the new message value", e, 500);
        }
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        Comment parent = root.adaptTo(Comment.class);
        if (parent != null && parent.isClosed()) {
            throw new OperationException("Reply attempted on closed comment: " + root.getPath(), 400);
        }
        long messageCharacterLimit = cs.getMessageCharacterLimit();
        String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
        if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
            throw new OperationException("Parameter message exceeded character limit", 400);
        }
        boolean bl = rootPathExists = this.getResource(cs.getRootPath(), session) != null;
        if (props.containsKey(PROP_MESSAGE)) {
            props.put("jcr:description", props.get(PROP_MESSAGE));
            props.remove(PROP_MESSAGE);
        }
        if (props.containsKey(TAGS_PROPERTY)) {
            props.put(CQ_TAGS_PROPERTY, props.get(TAGS_PROPERTY));
            props.remove(TAGS_PROPERTY);
        }
        if (props.containsKey(CQ_TAGS_PROPERTY) && !((v = props.get(CQ_TAGS_PROPERTY)) instanceof String[])) {
            if (v instanceof String) {
                if (String.valueOf(v).isEmpty()) {
                    props.remove(CQ_TAGS_PROPERTY);
                } else {
                    props.put(CQ_TAGS_PROPERTY, new String[]{(String)v});
                }
            } else {
                throw new OperationException("Parameter cq:tags is not a String Array", 400);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(postFix = this.getBucketPostFix(root)))) {
            cs.setBucketPostfix(postFix);
        }
        try {
            String entityUrl;
            ModifiableValueMap vm;
            Comment comment = cs.addComment(message, author, attachments, "", this.getResourceType(root, cs), props);
            if (SocialResourceUtils.isSocialResource(comment.getResource()) && (vm = comment.getResource().adaptTo(ModifiableValueMap.class)) != null && !StringUtils.isEmpty((CharSequence)(entityUrl = this.getEntityUrl(comment.getResource())))) {
                vm.put(":entity", entityUrl);
            }
            cs.save();
            LOG.info("Comment created: " + comment.getPath());
            if (!rootPathExists) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(cs.getRootPath());
                paths.add(comment.getPath());
                this.reverseReplicate(ReplicationActionType.ACTIVATE, paths);
            } else {
                this.reverseReplicate(comment.getPath());
            }
            this.postCreateEvent(cs, comment, author);
            this.performAfterActions(createOperation, session, comment, props);
            return comment.getResource();
        }
        catch (CommentException e) {
            this.cleanupFailure(session);
            throw new OperationException("Failed to create comment.", e, 500);
        }
    }

    private void cleanupFailure(Session session) {
        try {
            session.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.info("Failed to refresh the session", (Throwable)e);
        }
    }

    public Resource create(Resource root, String author, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(root, session);
        return this.create(root, cs, author, props, attachments, session);
    }

    public Resource create(SlingHttpServletRequest request, Session session) throws OperationException {
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        this.validateParameters(request);
        String name = this.getAuthorizableId(request, session);
        if (!this.mayPost(request, cs, name)) {
            throw new OperationException("User not allowed to post to forum at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException(e.getMessage(), e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        return this.create(resource, cs, name, props, attachments, session);
    }

    private String getStringProperty(String key, Map<String, Object> props) throws RepositoryException {
        Object obj = props.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Value) {
            return ((Value)obj).getString();
        }
        return obj.toString();
    }

    protected void validateParameters(SlingHttpServletRequest request) throws OperationException {
        String message = request.getParameter(PROP_MESSAGE);
        if (message == null || "".equals(message)) {
            throw new OperationException("Comment value is empty", 400);
        }
        if (this.isBot(request)) {
            throw new OperationException("Bot check failed: Parameter id is missing or has unexpected value", 412);
        }
    }

    protected boolean mayPost(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        Session checkSession = request.getResourceResolver().adaptTo(Session.class);
        return CollabUtil.canAddNode(checkSession, "/content/usergenerated");
    }

    protected boolean mayEdit(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        return CollabUtil.hasModeratePermissions(request.getResource()) || CollabUtil.isResourceOwner(request.getResource());
    }

    protected boolean mayDelete(SlingHttpServletRequest request, CommentSystem cs, String userId) throws OperationException {
        return this.mayEdit(request, cs, userId);
    }

    protected String getAuthorFromRequest(SlingHttpServletRequest request) {
        String name = request.getParameter("userIdentifier");
        if (StringUtils.isBlank((CharSequence)name)) {
            UserProperties up = request.getResourceResolver().adaptTo(UserProperties.class);
            String string = name = up == null ? null : up.getAuthorizableID();
            if (name == null) {
                name = "Anonymous";
            }
        }
        return name;
    }

    public Resource update(SlingHttpServletRequest request, Session session) throws OperationException {
        String userId;
        Resource resource = request.getResource();
        CommentSystem cs = this.getCommentSystem(resource, session);
        if (!this.mayEdit(request, cs, userId = this.getAuthorizableId(request, session))) {
            throw new OperationException("User not allowed to edit to forum at " + cs.getPath(), 412);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            this.getDefaultProperties(request, props, session);
            this.getCustomProperties(request, props, session);
        }
        catch (CommentException e) {
            throw new OperationException(e.getMessage(), e, 203);
        }
        catch (RepositoryException e) {
            throw new OperationException("Failed to get comment properties", e, 500);
        }
        List<DataSource> attachments = this.getAttachmentsFromRequest(request, cs);
        return this.update(resource, cs, props, attachments, session);
    }

    protected Resource update(Resource commentResource, CommentSystem cs, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        Comment comment = this.getComment(commentResource, session);
        if (comment == null) {
            throw new OperationException("Failed to get Commment for target " + commentResource.getPath(), 404);
        }
        if (comment.isClosed()) {
            throw new OperationException("Update attempted on closed comment: " + commentResource.getPath(), 400);
        }
        U updateOperation = this.getUpdateOperation();
        this.performBeforeActions(updateOperation, session, comment.getResource(), props);
        if (cs == null) {
            throw new OperationException("Failed to get comment system for target '" + comment.getResource().getPath() + "' ", 404);
        }
        try {
            ModifiableValueMap properties = comment.getResource().adaptTo(ModifiableValueMap.class);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (entry.getKey() == PROP_MESSAGE) {
                    long messageCharacterLimit = cs.getMessageCharacterLimit();
                    String message = CollabUtil.getValueString(entry.getValue());
                    if (message == null) {
                        throw new OperationException("Null value for comment message.", 400);
                    }
                    String normalizedMessage = Normalizer.normalize(message, Normalizer.Form.NFC);
                    if ((long)normalizedMessage.codePointCount(0, normalizedMessage.length()) > messageCharacterLimit) {
                        throw new OperationException("Parameter message exceeded character limit", 400);
                    }
                    properties.put("jcr:description", entry.getValue());
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
            properties.remove("approved");
            properties.put("moderate", Boolean.TRUE);
            properties.put("cq:lastModified", Calendar.getInstance());
            if (CollabUtil.hasModeratePermissions(comment.getResource())) {
                properties.put("cq:lastModifiedBy", session.getUserID());
            } else {
                properties.put("cq:lastModifiedBy", comment.getAuthor().getId());
            }
            if (attachments != null) {
                comment.addAttachments(attachments);
            }
            comment.getResource().getResourceResolver().commit();
            if (this.reverseReplicate) {
                this.reverseReplicate(comment.getPath());
            }
            Comment updatedComment = comment.getResource().adaptTo(Comment.class);
            String author = session.getUserID();
            this.postUpdateEvent(cs, updatedComment, author);
            this.performAfterActions(updateOperation, session, updatedComment, props);
            return updatedComment.getResource();
        }
        catch (RepositoryException e) {
            throw new OperationException(e.getMessage(), e, 500);
        }
        catch (PersistenceException e) {
            throw new OperationException(e.getMessage(), e, 500);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException(e.getMessage(), e, 500);
        }
    }

    public Resource update(Resource commentResource, Map<String, Object> props, List<DataSource> attachments, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        return this.update(commentResource, cs, props, attachments, session);
    }

    public void delete(SlingHttpServletRequest request, Session session) throws OperationException {
        String userId;
        Resource reqResource = request.getResource();
        CommentSystem cs = this.getCommentSystem(reqResource, session);
        if (!this.mayDelete(request, cs, userId = this.getAuthorizableId(request, session))) {
            throw new OperationException("User not allowed to delete " + cs.getPath(), 404);
        }
        this.delete(reqResource, cs, session);
    }

    public void delete(Resource commentResource, Session session) throws OperationException {
        CommentSystem cs = this.getCommentSystem(commentResource, session);
        this.delete(commentResource, cs, session);
    }

    public void delete(Resource commentResource, CommentSystem cs, Session session) throws OperationException {
        try {
            Comment comment = this.getComment(commentResource, session);
            if (comment == null) {
                throw new OperationException("Unable to get comment for resource at " + commentResource.getPath(), 404);
            }
            if (comment.isClosed()) {
                throw new OperationException("Delete attempted on closed comment: " + commentResource.getPath(), 400);
            }
            U deleteOperation = this.getDeleteOperation();
            this.performBeforeActions(deleteOperation, session, comment.getResource(), Collections.<String, Object>emptyMap());
            List<String> paths = this.getPaths(commentResource.getResourceResolver(), comment.getPath());
            comment.remove();
            session.save();
            if (this.reverseReplicate) {
                this.replicator.reverseReplicate(ReplicationActionType.DELETE, paths);
            }
            String author = session.getUserID();
            this.postDeleteEvent(cs, comment, author);
            this.performAfterActions(deleteOperation, session, comment, Collections.<String, Object>emptyMap());
        }
        catch (RepositoryException e) {
            throw new OperationException(e.getMessage(), e, 404);
        }
    }

    private List<String> getPaths(ResourceResolver resolver, String path) throws RepositoryException {
        ArrayList<String> paths = new ArrayList<String>();
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            return paths;
        }
        for (Resource child : resource.getChildren()) {
            paths.addAll(this.getPaths(resolver, child.getPath()));
        }
        paths.add(path);
        return paths;
    }

    protected String getEntityUrl(Resource resource) {
        return resource.adaptTo(CommentSystem.class).getUrl();
    }

    protected abstract void postCreateEvent(CommentSystem var1, Comment var2, String var3);

    protected abstract void postUpdateEvent(CommentSystem var1, Comment var2, String var3);

    protected abstract void postDeleteEvent(CommentSystem var1, Comment var2, String var3);

    protected abstract U getCreateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getUpdateOperation();

    protected abstract String getResourceType(Resource var1, CommentSystem var2);

    protected abstract String getBucketPostFix(Resource var1);

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        this.replicator = asyncReverseReplicator;
    }

    protected void unbindReplicator(AsyncReverseReplicator asyncReverseReplicator) {
        if (this.replicator == asyncReverseReplicator) {
            this.replicator = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

