/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.cors;

import com.adobe.cq.social.commons.cors.CORSConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.AuthenticationInfoPostProcessor;

@Component
@Service
@Property(name="Adobe Social CORS Post-Processor", value={"CORS Authentication post processor"})
public class CORSAuthInfoPostProcessor
implements AuthenticationInfoPostProcessor {
    @Override
    public void postProcess(AuthenticationInfo info, HttpServletRequest request, HttpServletResponse response) throws LoginException {
        String origin;
        if (CORSConfig.getInstance().isEnable() && (origin = request.getHeader("Origin")) != null && origin.length() > 0) {
            if (request.getMethod().equals("OPTIONS")) {
                String requestMethod = request.getHeader("Access-Control-Request-Method");
                if (requestMethod != null) {
                    String requestedHeaders = request.getHeader("Access-Control-Request-Headers");
                    response.setHeader("Access-Control-Allow-Origin", origin);
                    response.setHeader("Access-Control-Allow-Credentials", "true");
                    response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
                    response.setHeader("Access-Control-Max-Age", "1");
                    if (requestedHeaders != null) {
                        response.setHeader("origin, content-type, cookie", "origin, content-type, cookie," + requestedHeaders);
                    } else {
                        response.setHeader("Access-Control-Allow-Headers", "origin, content-type, cookie");
                    }
                }
            } else {
                response.setHeader("Access-Control-Allow-Origin", origin);
                response.setHeader("Access-Control-Allow-Credentials", "true");
            }
        }
    }
}

