/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.cors;

import com.adobe.cq.social.commons.cors.CORSConfig;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.util.Dictionary;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.sling.SlingFilter;
import org.apache.felix.scr.annotations.sling.SlingFilterScope;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingFilter(label="AEM Social Communities Authentication Filter", metatype=true, scope={SlingFilterScope.REQUEST}, order=-500)
public class CORSAuthenticationFilter
implements Filter {
    @Property(boolValue={false})
    private static final String CORS_ENABLING = "cors.enabling";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private Externalizer externalizer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.LOG.debug("CORSAuthenticationFilter initialize");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest && response instanceof SlingHttpServletResponse && CORSConfig.getInstance().isEnable()) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
            String localOrigin = this.externalizer.absoluteLink(slingRequest, slingRequest.getScheme(), "");
            String origin = slingRequest.getHeader("Origin");
            if (origin != null && origin.length() > 0 && !localOrigin.equals(origin)) {
                slingResponse.setHeader("Access-Control-Allow-Origin", origin);
                slingResponse.setHeader("Access-Control-Allow-Credentials", "true");
                this.LOG.debug("Set CORS Headers");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.LOG.info("Activating {}.", (Object)this.getClass().getName());
        Dictionary props = context.getProperties();
        Object prop = props.get(CORS_ENABLING);
        if (prop != null) {
            CORSConfig.getInstance().setCORSEnabling(Boolean.TRUE.equals(prop));
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

