/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.emailreply;

import com.adobe.cq.social.commons.emailreply.EmailContent;
import com.adobe.cq.social.commons.emailreply.EmailReplyService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class AbstractEmailEventListener
implements EventListener {
    private static final String PROCESSING_STATUS_PROP = "processingStatus";
    private static final String PROCESSING_STATUS_MSG_PROP = "processingStatusMsg";
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractEmailEventListener.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference
    private EmailReplyService emailReplyService;
    private ExecutorService eventExecutorService;
    private ObservationManager observationManager;
    private ResourceResolver resourceResolver;

    protected void activate(ComponentContext context) throws Exception {
        this.resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        this.observationManager = this.resourceResolver.adaptTo(Session.class).getWorkspace().getObservationManager();
        this.eventExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected ObservationManager getObservationManager() {
        return this.observationManager;
    }

    protected ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    protected ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            final Event event = events.nextEvent();
            if (event instanceof JackrabbitEvent && ((JackrabbitEvent)event).isExternal()) continue;
            this.eventExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    String nodePath = null;
                    Resource emailResource = null;
                    Resource resource = null;
                    EmailContent emailContent = null;
                    try {
                        nodePath = event.getPath();
                        AbstractEmailEventListener.this.LOGGER.debug("Email received at path  : [{}]", (Object)nodePath);
                        if (nodePath.endsWith("/message/jcr:content")) {
                            resource = AbstractEmailEventListener.this.resourceResolver.getResource(nodePath);
                            emailResource = resource.getParent().getParent();
                            AbstractEmailEventListener.this.setProcessingStatus(emailResource, "processing", null);
                            emailContent = AbstractEmailEventListener.this.emailReplyService.getMailContent(resource);
                            AbstractEmailEventListener.this.processEvent(resource, emailContent);
                        }
                    }
                    catch (Exception e) {
                        AbstractEmailEventListener.this.LOGGER.error("Error while processing email saved at path : " + nodePath + "  with error :  " + e.getMessage());
                        AbstractEmailEventListener.this.setProcessingStatus(emailResource, "failure", e.getMessage());
                        AbstractEmailEventListener.this.emailReplyService.sendFailureEmailReply(emailContent);
                    }
                    try {
                        AbstractEmailEventListener.this.LOGGER.info("Deleting Node : " + emailResource.getPath());
                        AbstractEmailEventListener.this.resourceResolver.delete(emailResource);
                        AbstractEmailEventListener.this.resourceResolver.commit();
                    }
                    catch (Exception e) {
                        AbstractEmailEventListener.this.LOGGER.error("Error while deleting node.", (Throwable)e);
                    }
                }
            });
        }
    }

    protected void setProcessingStatus(Resource emailResource, String processingStatus, String statusMsg) {
        if (emailResource != null) {
            try {
                Node emailNode = emailResource.adaptTo(Node.class);
                if (processingStatus != null) {
                    emailNode.setProperty(PROCESSING_STATUS_PROP, processingStatus);
                }
                if (statusMsg != null) {
                    emailNode.setProperty(PROCESSING_STATUS_MSG_PROP, statusMsg);
                }
            }
            catch (RepositoryException e) {
                this.LOGGER.error("error while saving setting processing status ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        try {
            if (this.observationManager != null) {
                this.observationManager.removeEventListener((EventListener)this);
                this.eventExecutorService.shutdown();
                this.LOGGER.info("Removed JCR Event Listener : " + this.getClass().getName());
            }
        }
        catch (RepositoryException re) {
            this.LOGGER.error("Error Removing Event Listener " + this.getClass().getName(), (Throwable)re);
        }
        finally {
            if (this.resourceResolver != null) {
                this.resourceResolver.close();
            }
        }
    }

    protected abstract void processEvent(Resource var1, EmailContent var2) throws Exception;

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindEmailReplyService(EmailReplyService emailReplyService) {
        this.emailReplyService = emailReplyService;
    }

    protected void unbindEmailReplyService(EmailReplyService emailReplyService) {
        if (this.emailReplyService == emailReplyService) {
            this.emailReplyService = null;
        }
    }
}

