/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.listing;

import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.FullTextConstraint;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcIndexerUtil;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFilterUtil {
    private static Map<String, Integer> MAP_INDEXED_TYPE = new HashMap<String, Integer>();
    private static final Logger LOG;
    private static String[] TEXT_SEARCH_PROPERTY;
    private static int NUMBER_FILTER_TOKENS;
    private static int FILTER_PROP_INDEX;
    private static int FILTER_OPERATOR_INDEX;
    private static int FILTER_EXPRESSION_INDEX;

    public static void parseOrFilters(String expressions, Map<String, ConstraintGroup> orFilters) throws QueryFilterException {
        if (StringUtils.isEmpty((CharSequence)expressions)) {
            throw new QueryFilterException("Empty filter.");
        }
        String[] filters = expressions.split("(?<!\\\\),");
        for (int i = 0; i < filters.length; ++i) {
            QueryFilter queryExpression = QueryFilter.parse(filters[i], Operator.Or);
            String constraintGroupName = queryExpression.getName();
            if (!orFilters.containsKey(constraintGroupName)) {
                ConstraintGroup cg = new ConstraintGroup();
                cg.setOperator(Operator.And);
                orFilters.put(constraintGroupName, cg);
            }
            orFilters.get(constraintGroupName).addConstraint(queryExpression.getConstraint());
        }
    }

    private static String getPropertyValue(String name, String input) throws QueryFilterException {
        Integer type = MAP_INDEXED_TYPE.get(name);
        if (type != null) {
            switch (MAP_INDEXED_TYPE.get(name)) {
                case 1: 
                case 3: {
                    return input;
                }
                case 6: {
                    Boolean value = Boolean.valueOf(input);
                    return value.toString();
                }
                case 5: {
                    Date date;
                    if (StringUtils.isNumeric((CharSequence)input)) {
                        date = new Date(Long.parseLong(input));
                    } else {
                        try {
                            Calendar calendar = DatatypeConverter.parseDateTime((String)input);
                            date = calendar.getTime();
                        }
                        catch (IllegalArgumentException e) {
                            throw new QueryFilterException("Error parsing input string", e);
                        }
                    }
                    return UgcIndexerUtil.dateToString(date);
                }
            }
            throw new QueryFilterException("The type of the " + name + "proeprty is not supported.");
        }
        throw new QueryFilterException("The property " + name + "is not indexed.");
    }

    public static List<ConstraintGroup> parseFilter(String[] filters) throws QueryFilterException {
        HashMap<String, ConstraintGroup> orFiltersMap = new HashMap<String, ConstraintGroup>();
        ArrayList<ConstraintGroup> andFilters = new ArrayList<ConstraintGroup>();
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                ConstraintGroup cg = new ConstraintGroup();
                cg.setOperator(Operator.And);
                andFilters.add(cg);
                QueryFilterUtil.parseOrFilters(filters[i], orFiltersMap);
                for (Map.Entry entry : orFiltersMap.entrySet()) {
                    cg.or((Constraint)entry.getValue());
                }
                orFiltersMap.clear();
            }
        }
        return andFilters;
    }

    static {
        MAP_INDEXED_TYPE.put("jcr:primaryType", 1);
        MAP_INDEXED_TYPE.put(":uuid", 1);
        MAP_INDEXED_TYPE.put(":path", 1);
        MAP_INDEXED_TYPE.put(":parent", 1);
        MAP_INDEXED_TYPE.put(":name", 1);
        MAP_INDEXED_TYPE.put("isFlagged", 6);
        MAP_INDEXED_TYPE.put("isSpam", 6);
        MAP_INDEXED_TYPE.put("read", 6);
        MAP_INDEXED_TYPE.put("influence", 6);
        MAP_INDEXED_TYPE.put("attachments", 6);
        MAP_INDEXED_TYPE.put("sentiment", 3);
        MAP_INDEXED_TYPE.put("flagged", 6);
        MAP_INDEXED_TYPE.put("added", 5);
        MAP_INDEXED_TYPE.put("modifiedDate", 5);
        MAP_INDEXED_TYPE.put("state", 1);
        MAP_INDEXED_TYPE.put("userIdentifier", 1);
        MAP_INDEXED_TYPE.put("parentPath", 1);
        MAP_INDEXED_TYPE.put("parentTitle", 1);
        MAP_INDEXED_TYPE.put("replies", 3);
        MAP_INDEXED_TYPE.put("jcr:title", 1);
        MAP_INDEXED_TYPE.put("jcr:description", 1);
        MAP_INDEXED_TYPE.put("attachments", 6);
        MAP_INDEXED_TYPE.put("sling:resourceType", 1);
        MAP_INDEXED_TYPE.put("parentPath", 1);
        MAP_INDEXED_TYPE.put("parentTitle", 1);
        MAP_INDEXED_TYPE.put("allowThreadedReply", 6);
        MAP_INDEXED_TYPE.put("answered", 6);
        MAP_INDEXED_TYPE.put("chosenanswered", 6);
        MAP_INDEXED_TYPE.put("tag", 1);
        MAP_INDEXED_TYPE.put("cq:tags", 1);
        MAP_INDEXED_TYPE.put("author_display_name", 1);
        LOG = LoggerFactory.getLogger(QueryFilterUtil.class);
        TEXT_SEARCH_PROPERTY = new String[]{"jcr:title", "jcr:description"};
        NUMBER_FILTER_TOKENS = 3;
        FILTER_PROP_INDEX = 0;
        FILTER_OPERATOR_INDEX = 1;
        FILTER_EXPRESSION_INDEX = 2;
    }

    public static class QueryFilter {
        private final Constraint constraint;
        private final String name;

        private QueryFilter(String name, Comparator comp, String value, Operator operator) throws QueryFilterException {
            if (StringUtils.isEmpty((CharSequence)name)) {
                throw new QueryFilterException("Name parameter can not be null.");
            }
            if (comp == null) {
                throw new QueryFilterException("Invalid comparator value");
            }
            if (StringUtils.isEmpty((CharSequence)value)) {
                throw new QueryFilterException("Value parameter can not be null.");
            }
            if (operator == null) {
                throw new QueryFilterException("Operator parameter can not be null.");
            }
            this.name = name;
            String formattedName = name.contains(":") ? "[" + name + "]" : name;
            String sValue = UgcFilter.escape(QueryFilterUtil.getPropertyValue(name, value));
            this.constraint = this.isTextSearchProperty(name, comp) ? new FullTextConstraint(sValue, formattedName) : new ValueConstraint<String>(formattedName, sValue, comp.getComparisonType(), operator);
        }

        public Constraint getConstraint() {
            return this.constraint;
        }

        public String getName() {
            return this.name;
        }

        public static QueryFilter parse(String filter, Operator operator) throws QueryFilterException {
            String[] words = filter.trim().split(" ", NUMBER_FILTER_TOKENS);
            if (words.length < NUMBER_FILTER_TOKENS) {
                throw new QueryFilterException("Invalid filter expression: " + filter);
            }
            String name = words[FILTER_PROP_INDEX].trim();
            Comparator comp = Comparator.fromString(words[FILTER_OPERATOR_INDEX].trim());
            String value = QueryFilter.escapeQueryValue(words[FILTER_EXPRESSION_INDEX].trim());
            return new QueryFilter(name, comp, value, operator);
        }

        private boolean isTextSearchProperty(String name, Comparator comp) {
            return comp == Comparator.LIKE;
        }

        private static String escapeQueryValue(String value) {
            String escapeValue = value;
            if (escapeValue.startsWith("'") && escapeValue.endsWith("'")) {
                escapeValue = escapeValue.substring(1, escapeValue.length() - 1);
            }
            if (escapeValue.startsWith("\"") && escapeValue.endsWith("\"")) {
                escapeValue = escapeValue.substring(1, escapeValue.length() - 1);
            }
            if (escapeValue.contains("\\,")) {
                escapeValue = escapeValue.replace("\\,", ",");
            }
            return escapeValue;
        }
    }

    public static enum Comparator {
        EQ(ComparisonType.Equals),
        NE(ComparisonType.NotEquals),
        LT(ComparisonType.LessThan),
        LTE(ComparisonType.LessThanOrEqualTo),
        GT(ComparisonType.GreaterThan),
        GTE(ComparisonType.GreaterThanOrEqualTo),
        LIKE(null);

        ComparisonType comparator;

        private Comparator(ComparisonType comparator) {
            this.comparator = comparator;
        }

        ComparisonType getComparisonType() {
            return this.comparator;
        }

        public static Comparator fromString(String text) throws QueryFilterException {
            if (text == null || text.length() == 0) {
                return null;
            }
            return Comparator.valueOf(text.toUpperCase());
        }
    }

    public static class QueryFilterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public QueryFilterException(String msg) {
            super(msg);
        }

        public QueryFilterException(String msg, Exception cause) {
            super(msg, cause);
        }

        public QueryFilterException(Exception cause) {
            super(cause);
        }
    }
}

