/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.notification;

import com.adobe.cq.social.commons.notification.MatchingFilter;
import com.adobe.cq.social.commons.notification.SubscriptionEntryDetail;
import com.adobe.cq.social.commons.notification.impl.SubscriptionEntryDetailImpl;
import com.day.cq.wcm.notification.AbstractSubscription;
import com.day.cq.wcm.notification.NotificationContext;
import com.day.cq.wcm.notification.NotificationManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.event.Event;

@Component(componentAbstract=true)
public abstract class AbstractSocialSubscription
extends AbstractSubscription {
    static final String PN_ACTIONS = "actions";
    static final String PN_PATHS = "paths";
    static final String PN_CHANNEL = "channel";
    static final String PN_TYPE = "type";
    @Reference
    private NotificationManager notificationService;

    public static SubscriptionEntryDetail getApplicableSubscription(Iterator<PersistableValueMap> configs, final String path, final MatchingFilter ... matchingFilters) {
        SubscriptionEntryDetail subscriptionEntryDetail = AbstractSocialSubscription.getApplicableSubscription(configs, new MatchingFilter(){

            @Override
            public boolean match(ValueMap configMap) {
                boolean match = true;
                for (MatchingFilter matchingFilter : matchingFilters) {
                    if (matchingFilter.match(configMap)) continue;
                    match = false;
                    break;
                }
                AbstractSubscription.Filter filter = new AbstractSubscription.Filter(new UnpersistableValueMap(configMap));
                boolean result = false;
                if (match) {
                    for (int i = 0; i < filter.list.length; ++i) {
                        result = filter.list[i].apply(path, result);
                    }
                }
                return match && result;
            }
        });
        return subscriptionEntryDetail;
    }

    private static SubscriptionEntryDetail getApplicableSubscription(Iterator<PersistableValueMap> configs, MatchingFilter matchingFilter) {
        TreeMap<String, SubscriptionEntryDetailImpl> results = new TreeMap<String, SubscriptionEntryDetailImpl>();
        while (configs.hasNext()) {
            PersistableValueMap config = configs.next();
            for (final String entryStr : config.get(PN_PATHS, new String[0])) {
                HashMap<String, Object> modified = new HashMap<String, Object>((Map)config){
                    private static final long serialVersionUID = 1L;
                    {
                        super(x0);
                        this.put(AbstractSocialSubscription.PN_PATHS, entryStr);
                    }
                };
                UnpersistableValueMap entryConfig = new UnpersistableValueMap((Map<String, Object>)modified);
                AbstractSubscription.Entry[] entries = new AbstractSubscription.Filter(entryConfig).getEntries();
                if (entries.length != 1) continue;
                AbstractSubscription.Entry entry = entries[0];
                SubscriptionEntryDetail.SubscriptionEntryRule rule = entry.allow ? SubscriptionEntryDetail.SubscriptionEntryRule.ALLOW : SubscriptionEntryDetail.SubscriptionEntryRule.DENY;
                modified.put(PN_PATHS, new StringBuilder(entry.path).append('|').append(entry.exact).append('|').append(true));
                if (!matchingFilter.match(entryConfig)) continue;
                results.put(entry.path, new SubscriptionEntryDetailImpl((ValueMap)config, rule, entry.path, entry.exact));
            }
        }
        String previousPath = null;
        Iterator it = results.descendingKeySet().iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (previousPath != null && previousPath.startsWith(path)) {
                it.remove();
                continue;
            }
            previousPath = path;
        }
        return results.values().iterator().hasNext() ? (SubscriptionEntryDetail)results.values().iterator().next() : null;
    }

    protected static boolean matchPathAndAction(String action, String path, PersistableValueMap context) {
        boolean result = false;
        if (null != path) {
            AbstractSubscription.Filter filter = new AbstractSubscription.Filter(context);
            boolean found = false;
            int index = 0;
            while (!found && index < filter.actions.length) {
                if (filter.actions[index].toLowerCase().equals(String.valueOf(action).toLowerCase())) {
                    found = true;
                    continue;
                }
                ++index;
            }
            if (found) {
                for (int i = 0; i < filter.list.length; ++i) {
                    result = filter.list[i].apply(path, result);
                }
            }
        }
        return result;
    }

    protected abstract boolean matchesImpl(PersistableValueMap var1, Event var2);

    private boolean matchConfigs(ValueMap map1, ValueMap map2) {
        return Arrays.equals(map1.get(PN_ACTIONS, new String[0]), map2.get(PN_ACTIONS, new String[0])) && Arrays.equals(map1.get(PN_PATHS, new String[0]), map2.get(PN_PATHS, new String[0])) && StringUtils.equalsIgnoreCase((String)((String)((Object)map1.get(PN_CHANNEL, String.class))), (String)((String)((Object)map2.get(PN_CHANNEL, String.class)))) && StringUtils.equalsIgnoreCase((String)((String)((Object)map1.get(PN_TYPE, String.class))), (String)((String)((Object)map2.get(PN_TYPE, String.class))));
    }

    @Override
    public boolean matches(NotificationContext context, final Event event) {
        SubscriptionEntryDetail subscriptionDetail = AbstractSocialSubscription.getApplicableSubscription(this.notificationService.getSubscriptionConfigurations(context.getUser()), new MatchingFilter(){

            @Override
            public boolean match(ValueMap configMap) {
                return AbstractSocialSubscription.this.matchesImpl(new UnpersistableValueMap(configMap), event);
            }
        });
        return subscriptionDetail != null && subscriptionDetail.getRule() == SubscriptionEntryDetail.SubscriptionEntryRule.ALLOW && this.matchConfigs(context.getConfiguration(), subscriptionDetail.getParentConfiguration());
    }

    protected void bindNotificationService(NotificationManager notificationManager) {
        this.notificationService = notificationManager;
    }

    protected void unbindNotificationService(NotificationManager notificationManager) {
        if (this.notificationService == notificationManager) {
            this.notificationService = null;
        }
    }

    static class UnpersistableValueMap
    extends ValueMapDecorator
    implements PersistableValueMap {
        UnpersistableValueMap(Map<String, Object> base) {
            super(base);
        }

        @Override
        public void save() throws PersistenceException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

